/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.password.PasswordEncoder;
import org.pac4j.core.exception.AccountNotFoundException;
import org.pac4j.core.exception.BadCredentialsException;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.MultipleAccountsFoundException;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.definition.ProfileDefinitionAware;
import org.pac4j.core.profile.service.ProfileService;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.JavaSerializationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProfileService<U extends CommonProfile>
extends ProfileDefinitionAware<U>
implements ProfileService<U>,
Authenticator<UsernamePasswordCredentials> {
    public static final String ID = "id";
    public static final String LINKEDID = "linkedid";
    public static final String SERIALIZED_PROFILE = "serializedprofile";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String usernameAttribute = "username";
    private String passwordAttribute = "password";
    private String idAttribute = "id";
    private PasswordEncoder passwordEncoder;
    private JavaSerializationHelper javaSerializationHelper = new JavaSerializationHelper();
    private String attributes;
    protected String[] attributeNames;

    @Override
    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull("profileDefinition", this.getProfileDefinition());
        CommonHelper.assertNotBlank("usernameAttribute", this.usernameAttribute);
        CommonHelper.assertNotBlank("passwordAttribute", this.passwordAttribute);
        CommonHelper.assertNotBlank("idAttribute", this.idAttribute);
        if (CommonHelper.isNotBlank(this.attributes)) {
            for (String attributeName : this.attributeNames = this.attributes.split(",")) {
                if (!this.getIdAttribute().equalsIgnoreCase(attributeName) && !LINKEDID.equalsIgnoreCase(attributeName) && !this.getUsernameAttribute().equalsIgnoreCase(attributeName) && !this.getPasswordAttribute().equalsIgnoreCase(attributeName) && !SERIALIZED_PROFILE.equalsIgnoreCase(attributeName)) continue;
                throw new TechnicalException("The 'getIdAttribute()', linkedid, 'getUsernameAttribute()', 'getPasswordAttribute()' and serializedprofile attributes are not allowed");
            }
        } else {
            this.attributeNames = new String[0];
        }
    }

    @Override
    public void create(U profile, String password) {
        this.init(null);
        CommonHelper.assertNotNull("profile", profile);
        CommonHelper.assertNotBlank("password", password);
        CommonHelper.assertNotBlank(ID, ((UserProfile)profile).getId());
        CommonHelper.assertNotBlank("username", ((CommonProfile)profile).getUsername());
        Map<String, Object> attributes = this.convertProfileAndPasswordToAttributes(profile, password);
        this.insert(attributes);
    }

    @Override
    public void update(U profile, String password) {
        this.init(null);
        CommonHelper.assertNotNull("profile", profile);
        CommonHelper.assertNotBlank(ID, ((UserProfile)profile).getId());
        CommonHelper.assertNotBlank("username", ((CommonProfile)profile).getUsername());
        Map<String, Object> attributes = this.convertProfileAndPasswordToAttributes(profile, password);
        this.update(attributes);
    }

    @Override
    public void remove(U profile) {
        this.init(null);
        CommonHelper.assertNotNull("profile", profile);
        this.removeById(((UserProfile)profile).getId());
    }

    @Override
    public void removeById(String id) {
        this.init(null);
        CommonHelper.assertNotBlank(ID, id);
        this.deleteById(id);
    }

    protected Map<String, Object> convertProfileAndPasswordToAttributes(U profile, String password) {
        HashMap<String, Object> storageAttributes = new HashMap<String, Object>();
        storageAttributes.put(this.getIdAttribute(), ((UserProfile)profile).getId());
        storageAttributes.put(LINKEDID, ((UserProfile)profile).getLinkedId());
        storageAttributes.put(this.getUsernameAttribute(), ((CommonProfile)profile).getUsername());
        if (CommonHelper.isNotBlank(password)) {
            String encodedPassword = this.passwordEncoder != null ? this.passwordEncoder.encode(password) : password;
            storageAttributes.put(this.getPasswordAttribute(), encodedPassword);
        }
        if (this.isLegacyMode()) {
            for (String attributeName : this.attributeNames) {
                storageAttributes.put(attributeName, ((UserProfile)profile).getAttribute(attributeName));
            }
        } else {
            storageAttributes.put(SERIALIZED_PROFILE, this.javaSerializationHelper.serializeToBase64((Serializable)profile));
        }
        return storageAttributes;
    }

    protected abstract void insert(Map<String, Object> var1);

    protected abstract void update(Map<String, Object> var1);

    protected abstract void deleteById(String var1);

    @Override
    public U findById(String id) {
        this.init(null);
        CommonHelper.assertNotBlank(this.getIdAttribute(), id);
        List<Map<String, Object>> listAttributes = this.read(this.defineAttributesToRead(), this.getIdAttribute(), id);
        return this.convertAttributesToProfile(listAttributes);
    }

    @Override
    public U findByLinkedId(String linkedId) {
        this.init(null);
        CommonHelper.assertNotBlank(LINKEDID, linkedId);
        List<Map<String, Object>> listAttributes = this.read(this.defineAttributesToRead(), LINKEDID, linkedId);
        return this.convertAttributesToProfile(listAttributes);
    }

    protected List<String> defineAttributesToRead() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.getIdAttribute());
        names.add(LINKEDID);
        if (this.isLegacyMode()) {
            names.add(this.getUsernameAttribute());
            names.addAll(Arrays.asList(this.attributeNames));
        } else {
            names.add(SERIALIZED_PROFILE);
        }
        return names;
    }

    protected U convertAttributesToProfile(List<Map<String, Object>> listStorageAttributes) {
        if (listStorageAttributes == null || listStorageAttributes.size() == 0) {
            return null;
        }
        Map<String, Object> storageAttributes = listStorageAttributes.get(0);
        String linkedId = (String)storageAttributes.get(LINKEDID);
        if (this.isLegacyMode()) {
            Object profile = this.getProfileDefinition().newProfile(new Object[0]);
            for (String attributeName : this.attributeNames) {
                this.getProfileDefinition().convertAndAdd((CommonProfile)profile, attributeName, storageAttributes.get(attributeName));
            }
            ((UserProfile)profile).setId(storageAttributes.get(this.getUsernameAttribute()));
            if (CommonHelper.isNotBlank(linkedId)) {
                ((UserProfile)profile).setLinkedId(linkedId);
            }
            return (U)profile;
        }
        CommonProfile profile = (CommonProfile)this.javaSerializationHelper.unserializeFromBase64((String)storageAttributes.get(SERIALIZED_PROFILE));
        Object id = storageAttributes.get(this.getIdAttribute());
        if (CommonHelper.isBlank(profile.getId()) && id != null) {
            profile.setId(id);
        }
        if (CommonHelper.isBlank(profile.getLinkedId()) && CommonHelper.isNotBlank(linkedId)) {
            profile.setLinkedId(linkedId);
        }
        return (U)profile;
    }

    protected abstract List<Map<String, Object>> read(List<String> var1, String var2, String var3);

    @Override
    public void validate(UsernamePasswordCredentials credentials, WebContext context) throws HttpAction, CredentialsException {
        this.init(context);
        CommonHelper.assertNotNull("credentials", credentials);
        String username = credentials.getUsername();
        String password = credentials.getPassword();
        CommonHelper.assertNotBlank("username", username);
        CommonHelper.assertNotBlank("password", password);
        List<String> attributesToRead = this.defineAttributesToRead();
        attributesToRead.add("password");
        try {
            List<Map<String, Object>> listAttributes = this.read(attributesToRead, this.getUsernameAttribute(), username);
            if (listAttributes == null || listAttributes.isEmpty()) {
                throw new AccountNotFoundException("No account found for: " + username);
            }
            if (listAttributes.size() > 1) {
                throw new MultipleAccountsFoundException("Too many accounts found for: " + username);
            }
            String retrievedPassword = (String)listAttributes.get(0).get(this.getPasswordAttribute());
            if (!this.passwordEncoder.matches(password, retrievedPassword)) {
                throw new BadCredentialsException("Bad credentials for: " + username);
            }
            U profile = this.convertAttributesToProfile(listAttributes);
            credentials.setUserProfile((CommonProfile)profile);
        }
        catch (TechnicalException e) {
            this.logger.debug("Authentication error", (Throwable)e);
            throw e;
        }
    }

    protected boolean isLegacyMode() {
        return this.attributes != null;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public JavaSerializationHelper getJavaSerializationHelper() {
        return this.javaSerializationHelper;
    }

    public void setJavaSerializationHelper(JavaSerializationHelper javaSerializationHelper) {
        this.javaSerializationHelper = javaSerializationHelper;
    }

    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    public String getPasswordAttribute() {
        return this.passwordAttribute;
    }

    public void setPasswordAttribute(String passwordAttribute) {
        this.passwordAttribute = passwordAttribute;
    }

    public String getIdAttribute() {
        return this.idAttribute;
    }

    public void setIdAttribute(String idAttribute) {
        this.idAttribute = idAttribute;
    }
}

