/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.github.scribejava.apis.Foursquare2Api;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.foursquare.FoursquareProfile;
import org.pac4j.oauth.profile.foursquare.FoursquareProfileCreator;
import org.pac4j.oauth.profile.foursquare.FoursquareProfileDefinition;

public class FoursquareClient
extends OAuth20Client<FoursquareProfile> {
    public FoursquareClient() {
    }

    public FoursquareClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void clientInit(WebContext context) {
        this.configuration.setApi(Foursquare2Api.instance());
        this.configuration.setProfileDefinition(new FoursquareProfileDefinition());
        this.configuration.setScope("user");
        this.setConfiguration(this.configuration);
        this.defaultProfileCreator(new FoursquareProfileCreator(this.configuration));
        this.defaultLogoutActionBuilder((ctx, profile, targetUrl) -> RedirectAction.redirect((String)"https://www.foursquare.com/logout"));
        super.clientInit(context);
    }
}

