/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.casoauthwrapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.scribejava.core.model.OAuth2AccessToken;
import java.util.Iterator;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.oauth.client.CasOAuthWrapperClient;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.casoauthwrapper.CasAuthenticationDateFormatter;
import org.pac4j.oauth.profile.casoauthwrapper.CasOAuthWrapperProfile;
import org.pac4j.oauth.profile.definition.OAuth20ProfileDefinition;

public class CasOAuthWrapperProfileDefinition
extends OAuth20ProfileDefinition<CasOAuthWrapperProfile> {
    public static final String IS_FROM_NEW_LOGIN = "isFromNewLogin";
    public static final String AUTHENTICATION_DATE = "authenticationDate";
    public static final String AUTHENTICATION_METHOD = "authenticationMethod";
    public static final String SUCCESSFUL_AUTHENTICATION_HANDLERS = "successfulAuthenticationHandlers";
    public static final String LONG_TERM_AUTHENTICATION_REQUEST_TOKEN_USED = "longTermAuthenticationRequestTokenUsed";

    public CasOAuthWrapperProfileDefinition() {
        super(x -> new CasOAuthWrapperProfile());
        this.primary(IS_FROM_NEW_LOGIN, (AttributeConverter)Converters.BOOLEAN);
        this.primary(AUTHENTICATION_DATE, (AttributeConverter)new CasAuthenticationDateFormatter());
        this.primary(AUTHENTICATION_METHOD, (AttributeConverter)Converters.STRING);
        this.primary(SUCCESSFUL_AUTHENTICATION_HANDLERS, (AttributeConverter)Converters.STRING);
        this.primary(LONG_TERM_AUTHENTICATION_REQUEST_TOKEN_USED, (AttributeConverter)Converters.BOOLEAN);
    }

    @Override
    public String getProfileUrl(OAuth2AccessToken accessToken, OAuth20Configuration configuration) {
        return ((CasOAuthWrapperClient)((Object)configuration.getClient())).getCasOAuthUrl() + "/profile";
    }

    @Override
    public CasOAuthWrapperProfile extractUserProfile(String body) throws HttpAction {
        CasOAuthWrapperProfile profile;
        block6: {
            profile = (CasOAuthWrapperProfile)this.newProfile(new Object[0]);
            JsonNode json2 = JsonHelper.getFirstNode(body);
            if (json2 == null) break block6;
            profile.setId(JsonHelper.getElement(json2, "id"));
            json2 = json2.get("attributes");
            if (json2 != null) {
                if (json2 instanceof ArrayNode) {
                    for (JsonNode json2 : json2) {
                        String attribute = (String)json2.fieldNames().next();
                        this.convertAndAdd(profile, attribute, JsonHelper.getElement(json2, attribute));
                    }
                } else if (json2 instanceof ObjectNode) {
                    Iterator keys = json2.fieldNames();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        this.convertAndAdd(profile, key, JsonHelper.getElement(json2, key));
                    }
                }
            }
        }
        return profile;
    }
}

