/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.creator;

import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuth1Token;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.oauth.OAuth10aService;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.pac4j.oauth.credentials.OAuth10Credentials;
import org.pac4j.oauth.profile.OAuth10Profile;
import org.pac4j.oauth.profile.OAuth20Profile;
import org.pac4j.oauth.profile.creator.OAuthProfileCreator;

public class OAuth10ProfileCreator<U extends OAuth10Profile>
extends OAuthProfileCreator<OAuth10Credentials, U, OAuth10Configuration, OAuth1Token> {
    public OAuth10ProfileCreator(OAuth10Configuration configuration) {
        super(configuration);
    }

    @Override
    protected OAuth1Token getAccessToken(OAuth10Credentials credentials) throws HttpAction {
        return credentials.getAccessToken();
    }

    @Override
    protected void addAccessTokenToProfile(U profile, OAuth1Token accessToken) {
        if (profile != null) {
            String token = accessToken.getToken();
            this.logger.debug("add access_token: {} to profile", (Object)token);
            ((OAuth20Profile)((Object)profile)).setAccessToken(token);
            ((OAuth10Profile)((Object)profile)).setAccessSecret(accessToken.getTokenSecret());
        }
    }

    @Override
    protected void signRequest(OAuth1Token token, OAuthRequest request) {
        ((OAuth10aService)((OAuth10Configuration)this.configuration).getService()).signRequest((OAuth1AccessToken)token, (AbstractRequest)request);
        if (((OAuth10Configuration)this.configuration).isTokenAsHeader()) {
            request.addHeader("Authorization", "Bearer " + token.getToken());
        }
    }
}

