/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.dropbox;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.OAuth2AccessToken;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.definition.OAuth20ProfileDefinition;
import org.pac4j.oauth.profile.dropbox.DropBoxProfile;

public class DropBoxProfileDefinition
extends OAuth20ProfileDefinition<DropBoxProfile> {
    public static final String REFERRAL_LINK = "referral_link";
    public static final String COUNTRY = "country";
    public static final String SHARED = "shared";
    public static final String QUOTA = "quota";
    public static final String NORMAL = "normal";
    public static final String EMAIL_VERIFIED = "email_verified";

    public DropBoxProfileDefinition() {
        super(x -> new DropBoxProfile());
        this.primary(REFERRAL_LINK, (AttributeConverter)Converters.STRING);
        this.primary(COUNTRY, (AttributeConverter)Converters.LOCALE);
        this.primary(REFERRAL_LINK, (AttributeConverter)Converters.URL);
        this.primary(EMAIL_VERIFIED, (AttributeConverter)Converters.BOOLEAN);
        this.secondary(SHARED, (AttributeConverter)Converters.LONG);
        this.secondary(QUOTA, (AttributeConverter)Converters.LONG);
        this.secondary(NORMAL, (AttributeConverter)Converters.LONG);
    }

    @Override
    public String getProfileUrl(OAuth2AccessToken token, OAuth20Configuration configuration) {
        return "https://api.dropbox.com/1/account/info";
    }

    @Override
    public DropBoxProfile extractUserProfile(String body) throws HttpAction {
        DropBoxProfile profile = (DropBoxProfile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(JsonHelper.getElement(json, "uid"));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd(profile, attribute, JsonHelper.getElement(json, attribute));
            }
            if ((json = (JsonNode)JsonHelper.getElement(json, "quota_info")) != null) {
                for (String attribute : this.getSecondaryAttributes()) {
                    this.convertAndAdd(profile, attribute, JsonHelper.getElement(json, attribute));
                }
            }
        }
        return profile;
    }
}

