/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.facebook;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import java.io.IOException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.HttpCommunicationException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.FacebookClient;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.profile.creator.OAuth20ProfileCreator;
import org.pac4j.oauth.profile.definition.OAuth20ProfileDefinition;
import org.pac4j.oauth.profile.facebook.FacebookProfile;
import org.pac4j.oauth.profile.facebook.FacebookProfileDefinition;

public class FacebookProfileCreator
extends OAuth20ProfileCreator<FacebookProfile> {
    private static final String EXCHANGE_TOKEN_URL = "https://graph.facebook.com/v2.8/oauth/access_token?grant_type=fb_exchange_token";
    private static final String EXCHANGE_TOKEN_PARAMETER = "fb_exchange_token";

    public FacebookProfileCreator(OAuth20Configuration configuration) {
        super(configuration);
    }

    @Override
    protected FacebookProfile retrieveUserProfileFromToken(OAuth2AccessToken accessToken) throws HttpAction {
        OAuth20ProfileDefinition profileDefinition = (OAuth20ProfileDefinition)((OAuth20Configuration)this.configuration).getProfileDefinition();
        FacebookClient client = (FacebookClient)((Object)((OAuth20Configuration)this.configuration).getClient());
        String profileUrl = profileDefinition.getProfileUrl(accessToken, this.configuration);
        String body = this.sendRequestForData(accessToken, profileUrl, Verb.GET);
        if (body == null) {
            throw new HttpCommunicationException("Not data found for accessToken: " + accessToken);
        }
        FacebookProfile profile = (FacebookProfile)((Object)profileDefinition.extractUserProfile(body));
        this.addAccessTokenToProfile(profile, accessToken);
        if (profile != null && client.isRequiresExtendedToken()) {
            String url = CommonHelper.addParameter((String)EXCHANGE_TOKEN_URL, (String)"client_id", (String)((OAuth20Configuration)this.configuration).getKey());
            url = CommonHelper.addParameter((String)url, (String)"client_secret", (String)((OAuth20Configuration)this.configuration).getSecret());
            url = this.addExchangeToken(url, accessToken);
            OAuthRequest request = this.createOAuthRequest(url, Verb.GET);
            long t0 = System.currentTimeMillis();
            Response response = request.send();
            int code = response.getCode();
            try {
                body = response.getBody();
            }
            catch (IOException ex) {
                throw new HttpCommunicationException("Error getting body:" + ex.getMessage());
            }
            long t1 = System.currentTimeMillis();
            this.logger.debug("Request took: " + (t1 - t0) + " ms for: " + url);
            this.logger.debug("response code: {} / response body: {}", (Object)code, (Object)body);
            if (code == 200) {
                OAuth2AccessToken extendedAccessToken;
                this.logger.debug("Retrieve extended token from  {}", (Object)body);
                try {
                    extendedAccessToken = (OAuth2AccessToken)((DefaultApi20)((OAuth20Configuration)this.configuration).getApi()).getAccessTokenExtractor().extract(response);
                }
                catch (OAuthException | IOException ex) {
                    throw new HttpCommunicationException("Error extracting token: " + ex.getMessage());
                }
                this.logger.debug("Extended token: {}", (Object)extendedAccessToken);
                this.addAccessTokenToProfile(profile, extendedAccessToken);
            } else {
                this.logger.error("Cannot get extended token: {} / {}", (Object)code, (Object)body);
            }
        }
        return profile;
    }

    protected String addExchangeToken(String url, OAuth2AccessToken accessToken) {
        FacebookProfileDefinition profileDefinition = (FacebookProfileDefinition)((OAuth20Configuration)this.configuration).getProfileDefinition();
        FacebookClient client = (FacebookClient)((Object)((OAuth20Configuration)this.configuration).getClient());
        String computedUrl = url;
        if (client.getUseAppSecretProof()) {
            computedUrl = profileDefinition.computeAppSecretProof(computedUrl, accessToken, (OAuth20Configuration)this.configuration);
        }
        return CommonHelper.addParameter((String)computedUrl, (String)EXCHANGE_TOKEN_PARAMETER, (String)accessToken.getAccessToken());
    }
}

