/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.redirect;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.oauth.OAuth10aService;
import java.io.IOException;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.HttpCommunicationException;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.redirect.RedirectActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth10RedirectActionBuilder
extends InitializableWebObject
implements RedirectActionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(OAuth10RedirectActionBuilder.class);
    protected final OAuth10Configuration configuration;

    public OAuth10RedirectActionBuilder(OAuth10Configuration configuration) {
        this.configuration = configuration;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.configuration.init(context);
    }

    public RedirectAction redirect(WebContext context) throws HttpAction {
        this.init(context);
        try {
            OAuth1RequestToken requestToken;
            try {
                requestToken = ((OAuth10aService)this.configuration.getService()).getRequestToken();
            }
            catch (IOException ex) {
                throw new HttpCommunicationException("Error getting token: " + ex.getMessage());
            }
            logger.debug("requestToken: {}", (Object)requestToken);
            context.setSessionAttribute(this.configuration.getRequestTokenSessionAttributeName(), (Object)requestToken);
            String authorizationUrl = ((OAuth10aService)this.configuration.getService()).getAuthorizationUrl(requestToken);
            logger.debug("authorizationUrl: {}", (Object)authorizationUrl);
            return RedirectAction.redirect((String)authorizationUrl);
        }
        catch (OAuthException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"configuration", this.configuration});
    }
}

