/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.github.scribejava.apis.LinkedInApi20;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2Profile;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2ProfileDefinition;

public class LinkedIn2Client
extends OAuth20Client<LinkedIn2Profile> {
    public static final String DEFAULT_SCOPE = "r_fullprofile";
    protected String scope = "r_fullprofile";
    protected String fields = "id,first-name,last-name,maiden-name,formatted-name,phonetic-first-name,phonetic-last-name,formatted-phonetic-name,headline,location,industry,current-share,num-connections,num-connections-capped,summary,specialties,positions,picture-url,site-standard-profile-request,api-standard-profile-request,public-profile-url,email-address";

    public LinkedIn2Client() {
    }

    public LinkedIn2Client(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void clientInit(WebContext context) {
        CommonHelper.assertNotBlank((String)"scope", (String)this.scope);
        CommonHelper.assertNotBlank((String)"fields", (String)this.fields);
        this.configuration.setApi(LinkedInApi20.instance());
        this.configuration.setProfileDefinition(new LinkedIn2ProfileDefinition());
        this.configuration.setScope(this.scope);
        this.configuration.setWithState(true);
        this.configuration.setHasBeenCancelledFactory(ctx -> {
            String error = ctx.getRequestParameter("error");
            String errorDescription = ctx.getRequestParameter("error_description");
            if ("access_denied".equals(error) && ("the+user+denied+your+request".equals(errorDescription) || "the user denied your request".equals(errorDescription))) {
                return true;
            }
            return false;
        });
        this.setConfiguration(this.configuration);
        this.defaultLogoutActionBuilder((ctx, profile, targetUrl) -> RedirectAction.redirect((String)"https://www.linkedin.com/uas/logout"));
        super.clientInit(context);
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getFields() {
        return this.fields;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }
}

