/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.config;

import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.SignatureType;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.oauth.OAuthService;
import java.util.function.Function;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;

public class OAuthConfiguration<C extends IndirectClient, S extends OAuthService<?>, T extends Token>
extends InitializableWebObject {
    public static final String OAUTH_TOKEN = "oauth_token";
    public static final String RESPONSE_TYPE_CODE = "code";
    private C client;
    private String key;
    private String secret;
    private boolean tokenAsHeader;
    private String responseType = "code";
    private String scope;
    private BaseApi<S> api;
    private boolean hasGrantType;
    private Function<WebContext, Boolean> hasBeenCancelledFactory = ctx -> false;
    private OAuthProfileDefinition profileDefinition;
    protected S service;
    private int connectTimeout = 500;
    private int readTimeout = 5000;

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull((String)"client", this.client);
        CommonHelper.assertNotBlank((String)"key", (String)this.key);
        CommonHelper.assertNotBlank((String)"secret", (String)this.secret);
        CommonHelper.assertNotNull((String)"api", this.api);
        CommonHelper.assertNotNull((String)"hasBeenCancelledFactory", this.hasBeenCancelledFactory);
        CommonHelper.assertNotNull((String)"profileDefinition", (Object)((Object)this.profileDefinition));
        this.service = this.buildService(context, null);
    }

    public S buildService(WebContext context, String state) {
        return (S)this.getApi().createService(this.buildOAuthConfig(context, state));
    }

    protected OAuthConfig buildOAuthConfig(WebContext context, String state) {
        String finalCallbackUrl = this.client.getUrlResolver().compute(this.client.getCallbackUrl(), context);
        return new OAuthConfig(this.key, this.secret, finalCallbackUrl, SignatureType.Header, this.scope, null, state, this.responseType, null, Integer.valueOf(this.connectTimeout), Integer.valueOf(this.readTimeout), null, null);
    }

    public S getService() {
        return this.service;
    }

    public C getClient() {
        return this.client;
    }

    public void setClient(C client) {
        this.client = client;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean isTokenAsHeader() {
        return this.tokenAsHeader;
    }

    public void setTokenAsHeader(boolean tokenAsHeader) {
        this.tokenAsHeader = tokenAsHeader;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public BaseApi<S> getApi() {
        return this.api;
    }

    public void setApi(BaseApi<S> api) {
        this.api = api;
    }

    public boolean isHasGrantType() {
        return this.hasGrantType;
    }

    public void setHasGrantType(boolean hasGrantType) {
        this.hasGrantType = hasGrantType;
    }

    public Function<WebContext, Boolean> getHasBeenCancelledFactory() {
        return this.hasBeenCancelledFactory;
    }

    public void setHasBeenCancelledFactory(Function<WebContext, Boolean> hasBeenCancelledFactory) {
        this.hasBeenCancelledFactory = hasBeenCancelledFactory;
    }

    public OAuthProfileDefinition getProfileDefinition() {
        return this.profileDefinition;
    }

    public void setProfileDefinition(OAuthProfileDefinition profileDefinition) {
        this.profileDefinition = profileDefinition;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"key", this.key, "secret", "[protected]", "tokenAsHeader", this.tokenAsHeader, "connectTimeout", this.connectTimeout, "readTimeout", this.readTimeout, "responseType", this.responseType, "scope", this.scope, "api", this.api, "hasGrantType", this.hasGrantType, "service", this.service, "hasBeenCancelledFactory", this.hasBeenCancelledFactory, "profileDefinition", this.profileDefinition});
    }
}

