/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.credentials.authenticator;

import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.IOException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.HttpCommunicationException;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.credentials.OAuth20Credentials;
import org.pac4j.oauth.credentials.OAuthCredentials;
import org.pac4j.oauth.credentials.authenticator.OAuthAuthenticator;
import org.pac4j.oauth.exception.OAuthCredentialsException;

public class OAuth20Authenticator
extends OAuthAuthenticator<OAuth20Credentials, OAuth20Configuration> {
    public OAuth20Authenticator(OAuth20Configuration configuration) {
        super(configuration);
    }

    @Override
    protected void retrieveAccessToken(OAuthCredentials credentials) throws HttpAction, OAuthCredentialsException {
        OAuth2AccessToken accessToken;
        OAuth20Credentials oAuth20Credentials = (OAuth20Credentials)credentials;
        String code = oAuth20Credentials.getCode();
        this.logger.debug("code: {}", (Object)code);
        try {
            accessToken = ((OAuth20Service)((OAuth20Configuration)this.configuration).getService()).getAccessToken(code);
        }
        catch (IOException ex) {
            throw new HttpCommunicationException("Error getting token:" + ex.getMessage());
        }
        this.logger.debug("accessToken: {}", (Object)accessToken);
        oAuth20Credentials.setAccessToken(accessToken);
    }
}

