/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.credentials.extractor;

import com.github.scribejava.core.exceptions.OAuthException;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.credentials.OAuthCredentials;
import org.pac4j.oauth.exception.OAuthCredentialsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class OAuthCredentialsExtractor<C extends OAuthCredentials, O extends OAuthConfiguration>
extends InitializableWebObject
implements CredentialsExtractor<C> {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final O configuration;

    protected OAuthCredentialsExtractor(O configuration) {
        this.configuration = configuration;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull((String)"configuration", this.configuration);
        this.configuration.init(context);
    }

    public C extract(WebContext context) throws HttpAction, CredentialsException {
        this.init(context);
        boolean hasBeenCancelled = ((OAuthConfiguration)((Object)this.configuration)).getHasBeenCancelledFactory().apply(context);
        if (hasBeenCancelled) {
            this.logger.debug("authentication has been cancelled by user");
            return null;
        }
        try {
            boolean errorFound = false;
            OAuthCredentialsException oauthCredentialsException = new OAuthCredentialsException("Failed to retrieve OAuth credentials, error parameters found");
            for (String key : OAuthCredentialsException.ERROR_NAMES) {
                String value = context.getRequestParameter(key);
                if (value == null) continue;
                errorFound = true;
                oauthCredentialsException.setErrorMessage(key, value);
            }
            if (errorFound) {
                throw oauthCredentialsException;
            }
            return this.getOAuthCredentials(context);
        }
        catch (OAuthException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected abstract C getOAuthCredentials(WebContext var1) throws HttpAction, CredentialsException;

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"configuration", this.configuration});
    }
}

