/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.foursquare;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.OAuth2AccessToken;
import java.util.Arrays;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.converter.JsonConverter;
import org.pac4j.oauth.profile.definition.OAuth20ProfileDefinition;
import org.pac4j.oauth.profile.foursquare.FoursquareProfile;
import org.pac4j.oauth.profile.foursquare.FoursquareUserContact;
import org.pac4j.oauth.profile.foursquare.FoursquareUserFriends;
import org.pac4j.oauth.profile.foursquare.FoursquareUserPhoto;

public class FoursquareProfileDefinition
extends OAuth20ProfileDefinition<FoursquareProfile> {
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    public static final String PHOTO = "photo";
    public static final String FIRENDS = "friends";
    public static final String HOME_CITY = "homeCity";
    public static final String CONTACT = "contact";
    public static final String BIO = "bio";

    public FoursquareProfileDefinition() {
        super(x -> new FoursquareProfile());
        Arrays.stream(new String[]{FIRST_NAME, LAST_NAME, HOME_CITY, BIO, PHOTO}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.STRING));
        this.primary("gender", (AttributeConverter)Converters.GENDER);
        this.primary(FIRENDS, new JsonConverter<FoursquareUserFriends>(FoursquareUserFriends.class));
        this.primary(CONTACT, new JsonConverter<FoursquareUserContact>(FoursquareUserContact.class));
        this.primary(PHOTO, new JsonConverter<FoursquareUserPhoto>(FoursquareUserPhoto.class));
    }

    @Override
    public String getProfileUrl(OAuth2AccessToken accessToken, OAuth20Configuration configuration) {
        return "https://api.foursquare.com/v2/users/self?v=20131118";
    }

    @Override
    public FoursquareProfile extractUserProfile(String body) throws HttpAction {
        FoursquareProfile profile = (FoursquareProfile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json == null) {
            return profile;
        }
        JsonNode response = (JsonNode)JsonHelper.getElement(json, "response");
        if (response == null) {
            return profile;
        }
        JsonNode user = (JsonNode)JsonHelper.getElement(response, "user");
        if (user != null) {
            profile.setId(JsonHelper.getElement(user, "id"));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd(profile, attribute, JsonHelper.getElement(user, attribute));
            }
        }
        return profile;
    }
}

