/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.paypal;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.OAuth2AccessToken;
import java.util.Arrays;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.converter.JsonConverter;
import org.pac4j.oauth.profile.definition.OAuth20ProfileDefinition;
import org.pac4j.oauth.profile.paypal.PayPalAddress;
import org.pac4j.oauth.profile.paypal.PayPalProfile;

public class PayPalProfileDefinition
extends OAuth20ProfileDefinition<PayPalProfile> {
    public static final String ADDRESS = "address";
    public static final String LANGUAGE = "language";
    public static final String ZONEINFO = "zoneinfo";
    public static final String NAME = "name";
    public static final String GIVEN_NAME = "given_name";

    public PayPalProfileDefinition() {
        super(x -> new PayPalProfile());
        Arrays.stream(new String[]{ZONEINFO, NAME, GIVEN_NAME}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.STRING));
        this.primary(ADDRESS, new JsonConverter<PayPalAddress>(PayPalAddress.class));
        this.primary(LANGUAGE, (AttributeConverter)Converters.LOCALE);
    }

    @Override
    public String getProfileUrl(OAuth2AccessToken accessToken, OAuth20Configuration configuration) {
        return "https://api.paypal.com/v1/identity/openidconnect/userinfo?schema=openid";
    }

    @Override
    public PayPalProfile extractUserProfile(String body) throws HttpAction {
        PayPalProfile profile = (PayPalProfile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            String userId = (String)JsonHelper.getElement(json, "user_id");
            profile.setId(CommonHelper.substringAfter((String)userId, (String)"/user/"));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd(profile, attribute, JsonHelper.getElement(json, attribute));
            }
        }
        return profile;
    }
}

