/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.scribe.builder.api;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.utils.OAuthEncoder;
import java.util.Map;

public class GenericApi20
extends DefaultApi20 {
    private static final String AUTHORIZATION_URL = "%s?response_type=code&client_id=%s&redirect_uri=%s";
    protected final String authUrl;
    protected final String tokenUrl;
    protected Verb accessTokenVerb = Verb.POST;

    public GenericApi20(String authUrl, String tokenUrl) {
        this.authUrl = authUrl;
        this.tokenUrl = tokenUrl;
    }

    public Verb getAccessTokenVerb() {
        return this.accessTokenVerb;
    }

    public void setAccessTokenVerb(Verb verb) {
        this.accessTokenVerb = verb;
    }

    public String getAccessTokenEndpoint() {
        return this.tokenUrl;
    }

    public String getAuthorizationUrl(OAuthConfig config, Map<String, String> additionalParams) {
        StringBuilder url = new StringBuilder(String.format(AUTHORIZATION_URL, this.authUrl, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback())));
        if (config.getScope() != null) {
            url.append("&scope=").append(OAuthEncoder.encode((String)config.getScope()));
        }
        if (config.getState() != null) {
            url.append("&state=").append(OAuthEncoder.encode((String)config.getState()));
        }
        if (additionalParams != null && !additionalParams.isEmpty()) {
            for (Map.Entry<String, String> entry : additionalParams.entrySet()) {
                if (entry.getValue() == null) continue;
                url.append("&").append((Object)entry.getKey()).append("=").append(OAuthEncoder.encode((String)entry.getValue().toString()));
            }
        }
        return url.toString();
    }

    protected String getAuthorizationBaseUrl() {
        return this.authUrl;
    }
}

