/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.client;

import java.util.ArrayList;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.client.SAML2ClientConfiguration;
import org.pac4j.saml.context.SAML2ContextProvider;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.context.SAMLContextProvider;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.credentials.authenticator.SAML2Authenticator;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.crypto.DefaultSignatureSigningParametersProvider;
import org.pac4j.saml.crypto.ExplicitSignatureTrustEngineProvider;
import org.pac4j.saml.crypto.KeyStoreCredentialProvider;
import org.pac4j.saml.crypto.KeyStoreDecryptionProvider;
import org.pac4j.saml.crypto.SAML2SignatureTrustEngineProvider;
import org.pac4j.saml.crypto.SignatureSigningParametersProvider;
import org.pac4j.saml.logout.SAML2LogoutActionBuilder;
import org.pac4j.saml.metadata.SAML2IdentityProviderMetadataResolver;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.metadata.SAML2ServiceProviderMetadataResolver;
import org.pac4j.saml.profile.SAML2Profile;
import org.pac4j.saml.redirect.SAML2RedirectActionBuilder;
import org.pac4j.saml.sso.SAML2ProfileHandler;
import org.pac4j.saml.sso.SAML2ResponseValidator;
import org.pac4j.saml.sso.impl.SAML2DefaultResponseValidator;
import org.pac4j.saml.sso.impl.SAML2WebSSOMessageReceiver;
import org.pac4j.saml.sso.impl.SAML2WebSSOMessageSender;
import org.pac4j.saml.sso.impl.SAML2WebSSOProfileHandler;
import org.pac4j.saml.util.Configuration;

public class SAML2Client
extends IndirectClient<SAML2Credentials, SAML2Profile> {
    public static final String SAML_RELAY_STATE_ATTRIBUTE = "samlRelayState";
    protected CredentialProvider credentialProvider;
    protected SAMLContextProvider contextProvider;
    protected SignatureSigningParametersProvider signatureSigningParametersProvider;
    protected SAML2ProfileHandler<AuthnRequest> profileHandler;
    protected SAML2ResponseValidator responseValidator;
    protected SAML2SignatureTrustEngineProvider signatureTrustEngineProvider;
    protected SAML2MetadataResolver idpMetadataResolver;
    protected SAML2MetadataResolver spMetadataResolver;
    protected Decrypter decrypter;
    protected SAML2ClientConfiguration configuration;

    public SAML2Client() {
    }

    public SAML2Client(SAML2ClientConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void clientInit(WebContext context) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.configuration.init(this.getName(), context);
        this.initCredentialProvider();
        this.initDecrypter();
        this.initSignatureSigningParametersProvider();
        ChainingMetadataResolver metadataManager = this.initChainingMetadataResolver(this.initIdentityProviderMetadataResolver(), this.initServiceProviderMetadataResolver(context));
        this.initSAMLContextProvider((MetadataResolver)metadataManager);
        this.initSignatureTrustEngineProvider((MetadataResolver)metadataManager);
        this.initSAMLResponseValidator();
        this.initSAMLProfileHandler();
        this.defaultRedirectActionBuilder(new SAML2RedirectActionBuilder(this));
        this.defaultCredentialsExtractor(ctx -> {
            SAML2MessageContext samlContext = this.contextProvider.buildContext(ctx);
            SAML2Credentials credentials = (SAML2Credentials)this.profileHandler.receive(samlContext);
            credentials.setClientName(this.getName());
            return credentials;
        });
        this.defaultAuthenticator(new SAML2Authenticator());
        this.defaultLogoutActionBuilder(new SAML2LogoutActionBuilder(this));
    }

    protected void initSAMLProfileHandler() {
        this.profileHandler = new SAML2WebSSOProfileHandler(new SAML2WebSSOMessageSender(this.signatureSigningParametersProvider, this.configuration.getDestinationBindingType(), this.configuration.isForceSignRedirectBindingAuthnRequest()), new SAML2WebSSOMessageReceiver(this.responseValidator));
    }

    protected void initSAMLResponseValidator() {
        this.responseValidator = new SAML2DefaultResponseValidator(this.signatureTrustEngineProvider, this.decrypter, this.configuration.getMaximumAuthenticationLifetime(), this.configuration.getWantsAssertionsSigned());
    }

    protected void initSignatureTrustEngineProvider(MetadataResolver metadataManager) {
        this.signatureTrustEngineProvider = new ExplicitSignatureTrustEngineProvider(metadataManager);
    }

    protected void initSAMLContextProvider(MetadataResolver metadataManager) {
        this.contextProvider = new SAML2ContextProvider(metadataManager, this.idpMetadataResolver, this.spMetadataResolver, this.configuration.getSamlMessageStorageFactory());
    }

    protected MetadataResolver initServiceProviderMetadataResolver(WebContext context) {
        this.spMetadataResolver = new SAML2ServiceProviderMetadataResolver(this.configuration, this.computeFinalCallbackUrl(context), this.credentialProvider);
        return this.spMetadataResolver.resolve();
    }

    protected MetadataResolver initIdentityProviderMetadataResolver() {
        this.idpMetadataResolver = new SAML2IdentityProviderMetadataResolver(this.configuration);
        return this.idpMetadataResolver.resolve();
    }

    protected void initCredentialProvider() {
        this.credentialProvider = new KeyStoreCredentialProvider(this.configuration);
    }

    protected void initDecrypter() {
        this.decrypter = new KeyStoreDecryptionProvider(this.credentialProvider).build();
    }

    protected void initSignatureSigningParametersProvider() {
        this.signatureSigningParametersProvider = new DefaultSignatureSigningParametersProvider(this.credentialProvider, this.configuration);
    }

    protected ChainingMetadataResolver initChainingMetadataResolver(MetadataResolver idpMetadataProvider, MetadataResolver spMetadataProvider) {
        ChainingMetadataResolver metadataManager = new ChainingMetadataResolver();
        metadataManager.setId(ChainingMetadataResolver.class.getCanonicalName());
        try {
            ArrayList<MetadataResolver> list = new ArrayList<MetadataResolver>();
            list.add(idpMetadataProvider);
            list.add(spMetadataProvider);
            metadataManager.setResolvers(list);
            metadataManager.initialize();
        }
        catch (ResolverException e) {
            throw new TechnicalException("Error adding idp or sp metadatas to manager", (Throwable)e);
        }
        catch (ComponentInitializationException e) {
            throw new TechnicalException("Error initializing manager", (Throwable)e);
        }
        return metadataManager;
    }

    public String getStateParameter(WebContext webContext) {
        String relayState = (String)webContext.getSessionAttribute(SAML_RELAY_STATE_ATTRIBUTE);
        webContext.setSessionAttribute(SAML_RELAY_STATE_ATTRIBUTE, (Object)"");
        return relayState == null ? this.computeFinalCallbackUrl(webContext) : relayState;
    }

    public final SAML2ResponseValidator getResponseValidator() {
        return this.responseValidator;
    }

    public final SAML2MetadataResolver getServiceProviderMetadataResolver() {
        return this.spMetadataResolver;
    }

    public final SAML2MetadataResolver getIdentityProviderMetadataResolver() {
        return this.idpMetadataResolver;
    }

    public final String getIdentityProviderResolvedEntityId() {
        return this.idpMetadataResolver.getEntityId();
    }

    public final String getServiceProviderResolvedEntityId() {
        return this.spMetadataResolver.getEntityId();
    }

    public void setConfiguration(SAML2ClientConfiguration configuration) {
        this.configuration = configuration;
    }

    public final SAML2ClientConfiguration getConfiguration() {
        return this.configuration;
    }

    public SAMLContextProvider getContextProvider() {
        return this.contextProvider;
    }

    public SAML2ProfileHandler<AuthnRequest> getProfileHandler() {
        return this.profileHandler;
    }

    public SignatureSigningParametersProvider getSignatureSigningParametersProvider() {
        return this.signatureSigningParametersProvider;
    }

    public SAML2SignatureTrustEngineProvider getSignatureTrustEngineProvider() {
        return this.signatureTrustEngineProvider;
    }

    static {
        CommonHelper.assertNotNull((String)"parserPool", (Object)Configuration.getParserPool());
        CommonHelper.assertNotNull((String)"marshallerFactory", (Object)Configuration.getMarshallerFactory());
        CommonHelper.assertNotNull((String)"unmarshallerFactory", (Object)Configuration.getUnmarshallerFactory());
        CommonHelper.assertNotNull((String)"builderFactory", (Object)Configuration.getBuilderFactory());
    }
}

