/*
 * Decompiled with CFR 0.152.
 */
package org.phoenix.model;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.phoenix.model.PerfBatchLogModel;
import org.phoenix.utils.GetNow;

@Entity
@Table(name="t_performance")
@BatchSize(size=30)
public class PhoenixJmeterBean {
    private int id;
    private int userId;
    private int slaveId;
    private String status;
    private Set<PerfBatchLogModel> perfBatchLogModels;
    private HashMap<String, String> params;
    private String caseName = "Jmeter\u7528\u4f8b";
    private String numThreads = "1";
    private String rampTime = "0";
    private String sampleErrorControl = "continue";
    private String continueForever = "false";
    private String controllerLoops = "1";
    private String requestImpl = "HttpClient4";
    private String taskAssort = "false";
    private String startTime = GetNow.getCurrentTime();
    private String endTime = GetNow.getCurrentTime();
    private String duration = "0";
    private String delayTime = "0";
    private String delayedStart = "true";
    private String fullUrl = "";
    private String domainURL = "";
    private String connectTimeOut = "";
    private String responseTimeOut = "";
    private String contentEncoding = "UTF-8";
    private String requestProtocol = "http";
    private String requestMethod = "GET";
    private String urlPort = "-1";
    private String urlPath = "";
    private String checkPointValue = "";
    private String checkPointType = "2";
    private String clearCache = "false";
    private String emailAttemper = "false";
    private String successLimit = "2";
    private String failureLimit = "2";
    private String failureSubject = "Jmeter\u6d4b\u8bd5\u7ed3\u679c\u81f3\u5c11\u6709" + this.failureLimit + "\u9879\u5931\u8d25";
    private String successSubject = "Jmeter\u6d4b\u8bd5\u7ed3\u679c\u81f3\u5c11\u6709" + this.successLimit + "\u9879\u6210\u529f";
    private String fromAddress = "";
    private String smtpHost = "";
    private String sendTo = "";
    private String emailServerLoginName = "";
    private String emailServerLoginPassword = "";
    private String authType = "SSL";
    private String enableRendzvous = "false";
    private String groupSize = "1";
    private String rendzvousTimeOut = "30000";
    private String enableThinkTime = "false";
    private String thinkTime = "0";
    private String checkType = "response_data";
    private String enableProxy = "false";
    private String proxyHost = "";
    private String proxyPort = "80";
    private String proxyUserName = "";
    private String proxyPassword = "";
    private String enableDataSet = "false";
    private String fileEncoding = "UTF-8";
    private String fileName = "";
    private String filePath = "";
    private String recycle = "true";
    private String variableNames = "";
    private String enableHeaders = "false";
    private String requestHeaders = "";
    private String className = "";
    private String methodName = "";
    private String monitedSlaves = "";
    private String useBodyString = "false";
    private String bodyString = "";

    private HashMap<String, String> analysisHeaders() {
        if (!"".equals(this.requestHeaders.trim()) && !this.requestHeaders.equals("\n")) {
            String[] headers;
            HashMap<String, String> headMap = new HashMap<String, String>();
            this.setEnableHeaders("true");
            for (String header : headers = this.requestHeaders.split("\n")) {
                if (!header.contains("->")) continue;
                String[] h = header.split("->");
                headMap.put(h[0], h[1]);
            }
            return headMap;
        }
        this.setEnableHeaders("false");
        return null;
    }

    public HashMap<String, Object> toHashMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("caseName", this.caseName);
        hashMap.put("numThreads", this.numThreads);
        hashMap.put("rampTime", this.rampTime);
        hashMap.put("sampleErrorControl", this.sampleErrorControl);
        hashMap.put("continueForever", this.continueForever);
        hashMap.put("controllerLoops", this.controllerLoops);
        try {
            hashMap.put("startTime", GetNow.currentTimeToLong(this.startTime, "yyyy-MM-dd HH:mm:ss") + "");
        }
        catch (ParseException e) {
            hashMap.put("startTime", "startTime error!");
        }
        try {
            hashMap.put("endTime", GetNow.currentTimeToLong(this.endTime, "yyyy-MM-dd HH:mm:ss") + "");
        }
        catch (ParseException e) {
            hashMap.put("endTime", "endTime error!");
        }
        hashMap.put("duration", this.duration);
        hashMap.put("delayTime", this.delayTime);
        hashMap.put("delayedStart", this.delayedStart);
        hashMap.put("domainURL", this.domainURL);
        hashMap.put("requestImpl", this.requestImpl);
        hashMap.put("connectTimeOut", this.connectTimeOut);
        hashMap.put("responseTimeOut", this.responseTimeOut);
        hashMap.put("contentEncoding", this.contentEncoding);
        hashMap.put("requestMethod", this.requestMethod);
        hashMap.put("checkPointValue", this.checkPointValue);
        hashMap.put("checkPointType", this.checkPointType);
        hashMap.put("clearCache", this.clearCache.equals("on") ? "true" : "false");
        hashMap.put("emailAttemper", this.emailAttemper.equals("on") ? "true" : "false");
        hashMap.put("successLimit", this.successLimit);
        hashMap.put("failureLimit", this.failureLimit);
        hashMap.put("failureSubject", this.failureSubject);
        hashMap.put("fromAddress", this.fromAddress);
        hashMap.put("smtpHost", this.smtpHost);
        hashMap.put("successSubject", this.successSubject);
        hashMap.put("sendTo", this.sendTo);
        hashMap.put("emailServerLoginName", this.emailServerLoginName);
        hashMap.put("emailServerLoginPassword", this.emailServerLoginPassword);
        hashMap.put("authType", this.authType);
        hashMap.put("requestProtocol", this.requestProtocol);
        hashMap.put("className", this.className);
        hashMap.put("enableRendzvous", this.enableRendzvous.equals("on") ? "true" : "false");
        hashMap.put("groupSize", this.groupSize);
        hashMap.put("rendzvousTimeOut", this.rendzvousTimeOut);
        hashMap.put("enableThinkTime", this.enableThinkTime.equals("on") ? "true" : "false");
        hashMap.put("thinkTime", this.thinkTime);
        hashMap.put("taskAssort", this.taskAssort.equals("on") ? "true" : "false");
        hashMap.put("methodName", this.methodName);
        hashMap.put("urlPort", this.urlPort.equals("-1") ? "80" : this.urlPort);
        hashMap.put("urlPath", this.urlPath);
        hashMap.put("params", this.params);
        hashMap.put("enableProxy", this.enableProxy.equals("on") ? "true" : "false");
        hashMap.put("proxyHost", this.proxyHost);
        hashMap.put("proxyPort", this.proxyPort);
        hashMap.put("proxyUserName", this.proxyUserName);
        hashMap.put("proxyPassword", this.proxyPassword);
        hashMap.put("enableDataSet", this.enableDataSet.equals("on") ? "true" : "false");
        hashMap.put("fileEncoding", this.fileEncoding);
        hashMap.put("fileName", this.fileName);
        hashMap.put("recycle", this.recycle.equals("on") ? "true" : "false");
        hashMap.put("variableNames", this.variableNames);
        hashMap.put("checkType", this.checkType);
        hashMap.put("requestHeaders", this.analysisHeaders());
        hashMap.put("enableHeaders", this.enableHeaders);
        hashMap.put("useBodyString", this.useBodyString.equals("on") ? "true" : "false");
        hashMap.put("bodyString", this.bodyString);
        return hashMap;
    }

    @Id
    @GeneratedValue
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public String getCaseName() {
        return this.caseName;
    }

    public void setCaseName(String caseName) {
        this.caseName = caseName;
    }

    public String getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(String numThreads) {
        this.numThreads = numThreads;
    }

    public String getRampTime() {
        return this.rampTime;
    }

    public void setRampTime(String rampTime) {
        this.rampTime = rampTime;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getDelayTime() {
        return this.delayTime;
    }

    public void setDelayTime(String delayTime) {
        this.delayTime = delayTime;
    }

    public String getSampleErrorControl() {
        return this.sampleErrorControl;
    }

    public void setSampleErrorControl(String sampleErrorControl) {
        this.sampleErrorControl = sampleErrorControl;
    }

    public String getContinueForever() {
        return this.continueForever;
    }

    public void setContinueForever(String continueForever) {
        this.continueForever = continueForever;
    }

    public String getControllerLoops() {
        return this.controllerLoops;
    }

    public void setControllerLoops(String controllerLoops) {
        this.controllerLoops = controllerLoops;
    }

    public String getDelayedStart() {
        return this.delayedStart;
    }

    public void setDelayedStart(String delayedStart) {
        this.delayedStart = delayedStart;
    }

    @Column(columnDefinition="mediumtext", length=2550)
    public String getDomainURL() {
        return this.domainURL;
    }

    public void setDomainURL(String domainURL) {
        this.domainURL = domainURL;
    }

    public String getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public void setConnectTimeOut(String connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
    }

    public String getResponseTimeOut() {
        return this.responseTimeOut;
    }

    public void setResponseTimeOut(String responseTimeOut) {
        this.responseTimeOut = responseTimeOut;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getCheckPointValue() {
        return this.checkPointValue;
    }

    public void setCheckPointValue(String checkPointValue) {
        this.checkPointValue = checkPointValue;
    }

    public String getCheckPointType() {
        return this.checkPointType;
    }

    public void setCheckPointType(String checkPointType) {
        this.checkPointType = checkPointType;
    }

    public String getClearCache() {
        return this.clearCache;
    }

    public void setClearCache(String clearCache) {
        this.clearCache = clearCache;
    }

    public String getEmailAttemper() {
        return this.emailAttemper;
    }

    public void setEmailAttemper(String emailAttemper) {
        this.emailAttemper = emailAttemper;
    }

    public String getSuccessLimit() {
        return this.successLimit;
    }

    public void setSuccessLimit(String successLimit) {
        this.successLimit = successLimit;
    }

    public String getFailureLimit() {
        return this.failureLimit;
    }

    public void setFailureLimit(String failureLimit) {
        this.failureLimit = failureLimit;
    }

    public String getFailureSubject() {
        return this.failureSubject;
    }

    public void setFailureSubject(String failureSubject) {
        this.failureSubject = failureSubject;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public String getSuccessSubject() {
        return this.successSubject;
    }

    public void setSuccessSubject(String successSubject) {
        this.successSubject = successSubject;
    }

    public String getSendTo() {
        return this.sendTo;
    }

    public void setSendTo(String sendTo) {
        this.sendTo = sendTo;
    }

    public String getEmailServerLoginName() {
        return this.emailServerLoginName;
    }

    public void setEmailServerLoginName(String emailServerLoginName) {
        this.emailServerLoginName = emailServerLoginName;
    }

    public String getEmailServerLoginPassword() {
        return this.emailServerLoginPassword;
    }

    public void setEmailServerLoginPassword(String emailServerLoginPassword) {
        this.emailServerLoginPassword = emailServerLoginPassword;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getRequestProtocol() {
        return this.requestProtocol;
    }

    public void setRequestProtocol(String requestProtocol) {
        this.requestProtocol = requestProtocol;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public int getSlaveId() {
        return this.slaveId;
    }

    public void setSlaveId(int slaveId) {
        this.slaveId = slaveId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTaskAssort() {
        return this.taskAssort;
    }

    public void setTaskAssort(String taskAssort) {
        this.taskAssort = taskAssort;
    }

    public String getEnableRendzvous() {
        return this.enableRendzvous;
    }

    public void setEnableRendzvous(String enableRendzvous) {
        this.enableRendzvous = enableRendzvous;
    }

    public String getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(String groupSize) {
        this.groupSize = groupSize;
    }

    public String getEnableThinkTime() {
        return this.enableThinkTime;
    }

    public void setEnableThinkTime(String enableThinkTime) {
        this.enableThinkTime = enableThinkTime;
    }

    public String getThinkTime() {
        return this.thinkTime;
    }

    public void setThinkTime(String thinkTime) {
        this.thinkTime = thinkTime;
    }

    public String getRendzvousTimeOut() {
        return this.rendzvousTimeOut;
    }

    public void setRendzvousTimeOut(String rendzvousTimeOut) {
        this.rendzvousTimeOut = rendzvousTimeOut;
    }

    public String getUrlPort() {
        return this.urlPort;
    }

    public void setUrlPort(String urlPort) {
        this.urlPort = urlPort;
    }

    @Column(columnDefinition="mediumtext", length=2550)
    public String getUrlPath() {
        return this.urlPath;
    }

    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
    }

    @Column(columnDefinition="mediumtext", length=2550)
    public String getFullUrl() {
        return this.fullUrl;
    }

    public void setFullUrl(String fullUrl) {
        this.fullUrl = fullUrl;
    }

    @OneToMany(mappedBy="phoenixJmeterBean", fetch=FetchType.EAGER, targetEntity=PerfBatchLogModel.class)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @Fetch(value=FetchMode.SUBSELECT)
    public Set<PerfBatchLogModel> getPerfBatchLogModels() {
        return this.perfBatchLogModels;
    }

    public void setPerfBatchLogModels(Set<PerfBatchLogModel> perfBatchLogModels) {
        this.perfBatchLogModels = perfBatchLogModels;
    }

    public String getMonitedSlaves() {
        return this.monitedSlaves;
    }

    public void setMonitedSlaves(String monitedSlaves) {
        this.monitedSlaves = monitedSlaves;
    }

    public String getEnableProxy() {
        return this.enableProxy;
    }

    public void setEnableProxy(String enableProxy) {
        this.enableProxy = enableProxy;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public void setProxyUserName(String proxyUserName) {
        this.proxyUserName = proxyUserName;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getEnableDataSet() {
        return this.enableDataSet;
    }

    public void setEnableDataSet(String enableDataSet) {
        this.enableDataSet = enableDataSet;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getRecycle() {
        return this.recycle;
    }

    public void setRecycle(String recycle) {
        this.recycle = recycle;
    }

    public String getVariableNames() {
        return this.variableNames;
    }

    public void setVariableNames(String variableNames) {
        this.variableNames = variableNames;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    @Transient
    public HashMap<String, String> getParams() {
        return this.params;
    }

    public void setParams(HashMap<String, String> params) {
        this.params = params;
    }

    public String getCheckType() {
        return this.checkType;
    }

    public void setCheckType(String checkType) {
        this.checkType = checkType;
    }

    @Column(columnDefinition="mediumtext", length=1000)
    public String getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(String requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    @Transient
    public String getEnableHeaders() {
        return this.enableHeaders;
    }

    public void setEnableHeaders(String enableHeaders) {
        this.enableHeaders = enableHeaders;
    }

    @Column(columnDefinition="mediumtext", length=6500)
    public String getBodyString() {
        return this.bodyString;
    }

    public void setBodyString(String bodyString) {
        this.bodyString = bodyString;
    }

    public String getUseBodyString() {
        return this.useBodyString;
    }

    public void setUseBodyString(String useBodyString) {
        this.useBodyString = useBodyString;
    }

    public String getRequestImpl() {
        return this.requestImpl;
    }

    public void setRequestImpl(String requestImpl) {
        this.requestImpl = requestImpl;
    }
}

