/*
 * Decompiled with CFR 0.152.
 */
package org.phoenix.web.model;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.validator.constraints.NotBlank;
import org.phoenix.enums.TaskStatusType;
import org.phoenix.web.enums.JobStatus;
import org.phoenix.web.enums.TaskType;
import org.phoenix.web.model.SlaveModel;
import org.phoenix.web.model.User;

@Entity
@Table(name="t_task")
public class TaskModel {
    private int id;
    private TaskType taskType;
    private String taskName;
    private String taskData;
    private String beanName;
    private JobStatus jobStatus;
    private SlaveModel slaveModel;
    private String taskParameter;
    private String message;
    private TaskStatusType taskStatusType;
    private Date startTime;
    private Date endTime;
    private Date lastTime;
    private User user;
    private int batchLogId;

    public TaskModel() {
    }

    public TaskModel(TaskType taskType, String taskName, String taskData, SlaveModel slaveModel, String taskParameter, TaskStatusType taskStatusType, User user) {
        this.taskType = taskType;
        this.taskName = taskName;
        this.taskData = taskData;
        this.slaveModel = slaveModel;
        this.taskParameter = taskParameter;
        this.taskStatusType = taskStatusType;
        this.user = user;
    }

    @Id
    @GeneratedValue
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Enumerated(value=EnumType.STRING)
    public TaskType getTaskType() {
        return this.taskType;
    }

    public void setTaskType(TaskType taskType) {
        this.taskType = taskType;
    }

    @NotBlank(message="\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    @Column(unique=true)
    public String getTaskName() {
        return this.taskName;
    }

    @Enumerated(value=EnumType.STRING)
    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getLastTime() {
        return this.lastTime;
    }

    public void setLastTime(Date lastTime) {
        this.lastTime = lastTime;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    @NotBlank(message="\u9700\u8981\u6267\u884c\u7684\u573a\u666f\u6216\u7528\u4f8b\u4e0d\u80fd\u4e3a\u7a7a")
    public String getTaskData() {
        return this.taskData;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTaskData(String taskData) {
        this.taskData = taskData;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="slaveId")
    public SlaveModel getSlaveModel() {
        return this.slaveModel;
    }

    public void setSlaveModel(SlaveModel slaveModel) {
        this.slaveModel = slaveModel;
    }

    public String getTaskParameter() {
        return this.taskParameter;
    }

    public void setTaskParameter(String taskParameter) {
        this.taskParameter = taskParameter;
    }

    @Enumerated(value=EnumType.STRING)
    public TaskStatusType getTaskStatusType() {
        return this.taskStatusType;
    }

    public void setTaskStatusType(TaskStatusType taskStatusType) {
        this.taskStatusType = taskStatusType;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="userId")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public int getBatchLogId() {
        return this.batchLogId;
    }

    public void setBatchLogId(int batchLogId) {
        this.batchLogId = batchLogId;
    }
}

