/*
 * Decompiled with CFR 0.152.
 */
package org.phoenix.web.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;
import org.phoenix.web.model.AttachModel;
import org.phoenix.web.model.TaskModel;

@Entity
@Table(name="t_user")
@BatchSize(size=30)
public class User
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int id;
    private String username;
    private String password;
    private String nickname;
    private int role;
    private String roleName;
    private String email;
    private Date createDate;
    private Set<TaskModel> taskModels;
    private Set<AttachModel> attachModels;

    public User() {
    }

    public User(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public User(int id) {
        this.id = id;
    }

    public User(int id, String nickname) {
        this.id = id;
        this.nickname = nickname;
    }

    @NotBlank(message="{user.email.notBlack}")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @OneToMany(mappedBy="user", targetEntity=TaskModel.class, cascade={CascadeType.ALL})
    @LazyCollection(value=LazyCollectionOption.EXTRA)
    @Fetch(value=FetchMode.SUBSELECT)
    public Set<TaskModel> getTaskModels() {
        return this.taskModels;
    }

    public void setTaskModels(Set<TaskModel> taskModels) {
        this.taskModels = taskModels;
    }

    @OneToMany(mappedBy="user", targetEntity=AttachModel.class)
    @LazyCollection(value=LazyCollectionOption.EXTRA)
    @Fetch(value=FetchMode.SUBSELECT)
    public Set<AttachModel> getAttachModels() {
        return this.attachModels;
    }

    public void setAttachModels(Set<AttachModel> attachModels) {
        this.attachModels = attachModels;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public int getRole() {
        return this.role;
    }

    public void setRole(int role) {
        this.role = role;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @Id
    @GeneratedValue
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @NotEmpty(message="{user.username.error}")
    @Column(unique=true, nullable=false)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @NotEmpty(message="{user.password.error}")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Column(nullable=false)
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }
}

