/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.NonRaw;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.common.value.qual.UnknownVal;

public final class GraphPlume {
    private GraphPlume() {
        throw new Error("do not instantiate");
    }

    public static <T> @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Map<T, @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown List<T>> dominators(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Map<T, @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown List<@KeyFor(value={"#1"}) @KeyFor(value={"#1"}) @KeyFor(value={"#1"}) T>> predecessors) {
        HashMap dom = new HashMap();
        Map<T, List<@KeyFor(value={"dom"}) T>> preds = predecessors;
        ArrayList<T> nodes = new ArrayList<T>(preds.keySet());
        ArrayList<@KeyFor(value={"preds", "dom"}) T> roots = new ArrayList<T>();
        ArrayList<@KeyFor(value={"preds", "dom"}) T> nonRoots = new ArrayList<T>();
        for (T node : preds.keySet()) {
            if (preds.get(node).isEmpty()) {
                Set<T> set = Collections.singleton(node);
                dom.put(node, new ArrayList<T>(set));
                roots.add(node);
                continue;
            }
            dom.put(node, new ArrayList<T>(nodes));
            nonRoots.add(node);
        }
        assert (roots.size() + nonRoots.size() == nodes.size());
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Object node : nonRoots) {
                ArrayList<Object> newDoms = null;
                assert (preds.containsKey(node));
                for (T pred : preds.get(node)) {
                    assert (dom.containsKey(pred));
                    @NonNull List domOfPred = (List)dom.get(pred);
                    if (newDoms == null) {
                        newDoms = new ArrayList<Object>(domOfPred);
                        continue;
                    }
                    newDoms.retainAll(domOfPred);
                }
                assert (newDoms != null) : "@AssumeAssertion(nullness): the loop was entered at least once because this is a non-root, which has at least one predecessor";
                newDoms.add(node);
                assert (dom.containsKey(node));
                if (((List)dom.get(node)).equals(newDoms)) continue;
                dom.put(node, newDoms);
                changed = true;
            }
        }
        for (Object node : preds.keySet()) {
            assert (dom.containsKey(node) && ((List)dom.get(node)).contains(node));
        }
        return dom;
    }

    public static <T> void print(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Map<T, @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown List<T>> graph, @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown PrintStream ps, @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int indent) {
        String indentString = "";
        for (int i = 0; i < indent; ++i) {
            indentString = indentString + " ";
        }
        for (T node : graph.keySet()) {
            ps.printf("%s%s%n", indentString, node);
            for (T child : graph.get(node)) {
                ps.printf("  %s%s%n", indentString, child);
            }
        }
    }
}

