/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.index.qual.IndexFor;
import org.checkerframework.checker.index.qual.IndexOrHigh;
import org.checkerframework.checker.index.qual.LTEqLengthOf;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.NonRaw;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.common.value.qual.ArrayLenRange;
import org.checkerframework.common.value.qual.MinLen;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class LimitedSizeIntSet
implements Serializable,
Cloneable {
    static final @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown long serialVersionUID = 20031021L;
    protected @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int @Nullable @ArrayLenRange(from=1, to=0x7FFFFFFF) @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @Initialized @NonRaw @MinLen(value=1) @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown [] values;
    @LessThanUnknown @LTEqLengthOf(value={"this.values"}) @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @IndexOrHigh(value={"values"}) @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @NonNegative @UnknownRegex @SignatureUnknown int numValues;
    private static @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean assertsEnabled = false;

    public LimitedSizeIntSet(@LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @Positive @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int maxValues) {
        if (assertsEnabled && maxValues <= 0) {
            throw new IllegalArgumentException("maxValues should be positive, is " + maxValues);
        }
        this.values = new int[maxValues];
        this.numValues = 0;
    }

    public void add(@UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int elt) {
        if (this.repNulled()) {
            return;
        }
        if (this.contains(elt)) {
            return;
        }
        if (this.numValues == this.values.length) {
            this.nullRep();
            return;
        }
        this.values[this.numValues] = elt;
        ++this.numValues;
    }

    public void addAll(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown LimitedSizeIntSet s) {
        boolean sameObject;
        boolean bl = sameObject = this == s;
        if (sameObject) {
            return;
        }
        if (this.repNulled()) {
            return;
        }
        if (s.repNulled()) {
            if (s.size() > this.values.length) {
                this.nullRep();
                return;
            }
            throw new Error("Arg is rep-nulled, so we don't know its values and can't add them to this.");
        }
        int[] svalues = s.values;
        int i = 0;
        while (i < s.size()) {
            @IndexFor(value={"svalues"}) int index = i++;
            this.add(svalues[index]);
            if (!this.repNulled()) continue;
            return;
        }
    }

    @Pure
    public @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean contains(@UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int elt) {
        if (this.repNulled()) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < this.numValues; ++i) {
            if (this.values[i] != elt) continue;
            return true;
        }
        return false;
    }

    @Pure
    public @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int size(@GuardSatisfied LimitedSizeIntSet this) {
        return this.numValues;
    }

    public @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @Positive @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int maxSize() {
        if (this.repNulled()) {
            return this.numValues;
        }
        return this.values.length + 1;
    }

    @EnsuresNonNullIf(result=false, expression={"values"})
    @Pure
    public @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean repNulled(@GuardSatisfied LimitedSizeIntSet this) {
        return this.values == null;
    }

    private void nullRep() {
        if (this.repNulled()) {
            return;
        }
        this.numValues = this.values.length + 1;
        this.values = null;
    }

    @SideEffectFree
    public @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown LimitedSizeIntSet clone(@GuardSatisfied LimitedSizeIntSet this) {
        LimitedSizeIntSet result;
        try {
            result = (LimitedSizeIntSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error();
        }
        if (this.values != null) {
            result.values = (int[])this.values.clone();
        }
        return result;
    }

    public static @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown LimitedSizeIntSet merge(@LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @Positive @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int maxValues, @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown List<@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown LimitedSizeIntSet> slist) {
        LimitedSizeIntSet result = new LimitedSizeIntSet(maxValues);
        for (LimitedSizeIntSet s : slist) {
            result.addAll(s);
        }
        return result;
    }

    @SideEffectFree
    public @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String toString(@GuardSatisfied LimitedSizeIntSet this) {
        return "[size=" + this.size() + "; " + Arrays.toString(this.values) + "]";
    }

    static {
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }
}

