/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.transformers.javassist;

import javassist.CtClass;
import javassist.Modifier;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.InnerClassesAttribute;
import org.powermock.core.transformers.TransformStrategy;
import org.powermock.core.transformers.javassist.AbstractJavaAssistMockTransformer;

public class ClassFinalModifierMockTransformer
extends AbstractJavaAssistMockTransformer {
    public ClassFinalModifierMockTransformer(TransformStrategy strategy) {
        super(strategy);
    }

    @Override
    public CtClass transform(CtClass clazz) {
        if (clazz.isInterface()) {
            return clazz;
        }
        if (this.getStrategy() != TransformStrategy.INST_REDEFINE) {
            ClassFile classFile;
            AttributeInfo attribute;
            if (Modifier.isFinal((int)clazz.getModifiers())) {
                clazz.setModifiers(clazz.getModifiers() ^ 0x10);
            }
            if ((attribute = (classFile = clazz.getClassFile2()).getAttribute("InnerClasses")) != null && attribute instanceof InnerClassesAttribute) {
                InnerClassesAttribute ica = (InnerClassesAttribute)attribute;
                String name = classFile.getName();
                int n = ica.tableLength();
                for (int i = 0; i < n; ++i) {
                    int accessFlags;
                    if (!name.equals(ica.innerClass(i)) || !Modifier.isFinal((int)(accessFlags = ica.accessFlags(i)))) continue;
                    ica.setAccessFlags(i, accessFlags ^ 0x10);
                }
            }
        }
        return clazz;
    }
}

