/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.factory;

import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.Assert;
import reactor.core.Environment;
import reactor.core.Reactor;
import reactor.core.spec.ReactorSpec;
import reactor.core.spec.Reactors;
import reactor.spring.factory.EventRouting;

public class ReactorFactoryBean
implements FactoryBean<Reactor> {
    private volatile Reactor reactor;

    public ReactorFactoryBean(Environment env) {
        this(env, null, null);
    }

    public ReactorFactoryBean(Environment env, String dispatcher) {
        this(env, dispatcher, null);
    }

    public ReactorFactoryBean(Environment env, String dispatcher, EventRouting eventRouting) {
        Assert.notNull((Object)env, (String)"Environment cannot be null.");
        ReactorSpec spec = (ReactorSpec)Reactors.reactor().env(env);
        if (null != dispatcher) {
            if ("sync".equals(dispatcher)) {
                spec.synchronousDispatcher();
            } else {
                spec.dispatcher(dispatcher);
            }
        }
        if (null != eventRouting) {
            switch (eventRouting) {
                case BROADCAST_EVENT_ROUTING: {
                    spec.broadcastEventRouting();
                    break;
                }
                case RANDOM_EVENT_ROUTING: {
                    spec.randomEventRouting();
                    break;
                }
                case ROUND_ROBIN_EVENT_ROUTING: {
                    spec.roundRobinEventRouting();
                }
            }
        }
        this.reactor = (Reactor)spec.get();
    }

    public Reactor getObject() throws Exception {
        return this.reactor;
    }

    public Class<?> getObjectType() {
        return Reactor.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

