/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.reactive.MapReactiveIterator;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.springframework.data.redis.connection.ReactiveHashCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveHashCommands
extends RedissonBaseReactive
implements ReactiveHashCommands {
    private static final RedisCommand<String> HMSET = new RedisCommand("HMSET");
    private static final RedisCommand<List<Object>> HMGET = new RedisCommand("HMGET", (MultiDecoder)new MultiDecoder<List<Object>>(){

        public Decoder<Object> getDecoder(int paramNum, State state) {
            return null;
        }

        public List<Object> decode(List<Object> parts, State state) {
            List list = parts.stream().filter(e -> e != null).collect(Collectors.toList());
            if (list.isEmpty()) {
                return null;
            }
            return parts;
        }
    });
    private static final RedisCommand<Long> HSTRLEN = new RedisCommand("HSTRLEN");

    RedissonReactiveHashCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveHashCommands.HSetCommand>> hSet(Publisher<ReactiveHashCommands.HSetCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getFieldValueMap(), (String)"FieldValueMap must not be null!");
            byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            if (command.getFieldValueMap().size() == 1) {
                Map.Entry entry = command.getFieldValueMap().entrySet().iterator().next();
                byte[] mapKeyBuf = RedissonReactiveHashCommands.toByteArray((ByteBuffer)entry.getKey());
                byte[] mapValueBuf = RedissonReactiveHashCommands.toByteArray((ByteBuffer)entry.getValue());
                RedisStrictCommand cmd = RedisCommands.HSETNX;
                if (command.isUpsert()) {
                    cmd = RedisCommands.HSET;
                }
                Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)cmd, keyBuf, mapKeyBuf, mapValueBuf);
                return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, v));
            }
            ArrayList<byte[]> params = new ArrayList<byte[]>(command.getFieldValueMap().size() * 2 + 1);
            params.add(keyBuf);
            for (Map.Entry entry : command.getFieldValueMap().entrySet()) {
                params.add(RedissonReactiveHashCommands.toByteArray((ByteBuffer)entry.getKey()));
                params.add(RedissonReactiveHashCommands.toByteArray((ByteBuffer)entry.getValue()));
            }
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, HMSET, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, Boolean.valueOf(true)));
        });
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveHashCommands.HGetCommand, ByteBuffer>> hMGet(Publisher<ReactiveHashCommands.HGetCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getFields(), (String)"Fields must not be null!");
            byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            ArrayList<byte[]> args = new ArrayList<byte[]>(command.getFields().size() + 1);
            args.add(keyBuf);
            args.addAll(command.getFields().stream().map(buf -> RedissonReactiveHashCommands.toByteArray(buf)).collect(Collectors.toList()));
            Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, HMGET, args.toArray());
            return m.map(v -> {
                List values = v.stream().map(array -> {
                    if (array != null) {
                        return ByteBuffer.wrap(array);
                    }
                    return null;
                }).collect(Collectors.toList());
                return new ReactiveRedisConnection.MultiValueResponse(command, values);
            });
        });
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveHashCommands.HExistsCommand>> hExists(Publisher<ReactiveHashCommands.HExistsCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getField(), (String)"Field must not be null!");
            byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            byte[] fieldBuf = RedissonReactiveHashCommands.toByteArray(command.getField());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, RedisCommands.HEXISTS, keyBuf, fieldBuf);
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HDelCommand, Long>> hDel(Publisher<ReactiveHashCommands.HDelCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getFields(), (String)"Fields must not be null!");
            ArrayList<byte[]> args = new ArrayList<byte[]>(command.getFields().size() + 1);
            args.add(RedissonReactiveHashCommands.toByteArray(command.getKey()));
            args.addAll(command.getFields().stream().map(v -> RedissonReactiveHashCommands.toByteArray(v)).collect(Collectors.toList()));
            Mono m = this.write((byte[])args.get(0), (Codec)StringCodec.INSTANCE, RedisCommands.HDEL, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> hLen(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.HLEN_LONG, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<ByteBuffer>>> hKeys(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.HKEYS, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.CommandResponse(command, (Object)Flux.fromIterable((Iterable)v).map(e -> ByteBuffer.wrap(e))));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<ByteBuffer>>> hVals(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.HVALS, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.CommandResponse(command, (Object)Flux.fromIterable((Iterable)v).map(e -> ByteBuffer.wrap(e))));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<Map.Entry<ByteBuffer, ByteBuffer>>>> hGetAll(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.HGETALL, new Object[]{keyBuf});
            Mono f = m.map(v -> v.entrySet().stream().collect(Collectors.toMap(e -> ByteBuffer.wrap((byte[])e.getKey()), e -> ByteBuffer.wrap((byte[])e.getValue()))));
            return f.map(v -> new ReactiveRedisConnection.CommandResponse(command, (Object)Flux.fromIterable(v.entrySet())));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<Map.Entry<ByteBuffer, ByteBuffer>>>> hScan(Publisher<ReactiveRedisConnection.KeyScanCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getOptions(), (String)"ScanOptions must not be null!");
            final byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            Flux flux = Flux.create((Consumer)new MapReactiveIterator<Object, Object, Map.Entry<Object, Object>>(null, null, 0){

                public RFuture<MapScanResult<Object, Object>> scanIterator(RedisClient client, long nextIterPos) {
                    if (command.getOptions().getPattern() == null) {
                        return RedissonReactiveHashCommands.this.executorService.readAsync(client, keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.HSCAN, new Object[]{keyBuf, nextIterPos, "COUNT", Optional.ofNullable(command.getOptions().getCount()).orElse(10L)});
                    }
                    return RedissonReactiveHashCommands.this.executorService.readAsync(client, keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.HSCAN, new Object[]{keyBuf, nextIterPos, "MATCH", command.getOptions().getPattern(), "COUNT", Optional.ofNullable(command.getOptions().getCount()).orElse(10L)});
                }
            });
            Flux f = flux.map(v -> Collections.singletonMap(ByteBuffer.wrap((byte[])v.getKey()), ByteBuffer.wrap((byte[])v.getValue())).entrySet().iterator().next());
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)f));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HStrLenCommand, Long>> hStrLen(Publisher<ReactiveHashCommands.HStrLenCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getField(), (String)"Field must not be null!");
            byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            byte[] fieldBuf = RedissonReactiveHashCommands.toByteArray(command.getField());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, HSTRLEN, keyBuf, fieldBuf);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }
}

