/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.redisson.Redisson;
import org.redisson.RedissonReactive;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.config.Config;
import org.redisson.connection.SentinelConnectionManager;
import org.redisson.spring.data.connection.RedissonClusterConnection;
import org.redisson.spring.data.connection.RedissonConnection;
import org.redisson.spring.data.connection.RedissonExceptionConverter;
import org.redisson.spring.data.connection.RedissonReactiveRedisClusterConnection;
import org.redisson.spring.data.connection.RedissonReactiveRedisConnection;
import org.redisson.spring.data.connection.RedissonSentinelConnection;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.PassThroughExceptionTranslationStrategy;
import org.springframework.data.redis.connection.ReactiveRedisClusterConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConnection;

public class RedissonConnectionFactory
implements RedisConnectionFactory,
ReactiveRedisConnectionFactory,
InitializingBean,
DisposableBean {
    private static final Log log = LogFactory.getLog(RedissonConnectionFactory.class);
    public static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new PassThroughExceptionTranslationStrategy((Converter)new RedissonExceptionConverter());
    private Config config;
    private RedissonClient redisson;
    private boolean hasOwnRedisson;

    public RedissonConnectionFactory() {
        this(Redisson.create());
        this.hasOwnRedisson = true;
    }

    public RedissonConnectionFactory(RedissonClient redisson) {
        this.redisson = redisson;
    }

    public RedissonConnectionFactory(Config config) {
        this.config = config;
        this.hasOwnRedisson = true;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return EXCEPTION_TRANSLATION.translate((Exception)ex);
    }

    public void destroy() throws Exception {
        if (this.hasOwnRedisson) {
            this.redisson.shutdown();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.config != null) {
            this.redisson = Redisson.create((Config)this.config);
        }
    }

    public org.springframework.data.redis.connection.RedisConnection getConnection() {
        if (this.redisson.getConfig().isClusterConfig()) {
            return new RedissonClusterConnection(this.redisson);
        }
        return new RedissonConnection(this.redisson);
    }

    public RedisClusterConnection getClusterConnection() {
        if (!this.redisson.getConfig().isClusterConfig()) {
            throw new InvalidDataAccessResourceUsageException("Redisson is not in Cluster mode");
        }
        return new RedissonClusterConnection(this.redisson);
    }

    public boolean getConvertPipelineAndTxResults() {
        return true;
    }

    public RedisSentinelConnection getSentinelConnection() {
        if (!this.redisson.getConfig().isSentinelConfig()) {
            throw new InvalidDataAccessResourceUsageException("Redisson is not in Sentinel mode");
        }
        SentinelConnectionManager manager = (SentinelConnectionManager)((Redisson)this.redisson).getCommandExecutor().getConnectionManager();
        for (RedisClient client : manager.getSentinels()) {
            RedisConnection connection = null;
            try {
                connection = client.connect();
                String res = (String)connection.sync(RedisCommands.PING, new Object[0]);
                if (!"pong".equalsIgnoreCase(res)) continue;
                return new RedissonSentinelConnection(connection);
            }
            catch (Exception e) {
                log.warn((Object)("Can't connect to " + client), (Throwable)e);
                if (connection == null) continue;
                connection.closeAsync();
            }
        }
        throw new InvalidDataAccessResourceUsageException("Sentinels are offline");
    }

    public ReactiveRedisConnection getReactiveConnection() {
        if (this.redisson.getConfig().isClusterConfig()) {
            return new RedissonReactiveRedisClusterConnection(((RedissonReactive)this.redisson.reactive()).getCommandExecutor());
        }
        return new RedissonReactiveRedisConnection(((RedissonReactive)this.redisson.reactive()).getCommandExecutor());
    }

    public ReactiveRedisClusterConnection getReactiveClusterConnection() {
        if (!this.redisson.getConfig().isClusterConfig()) {
            throw new InvalidDataAccessResourceUsageException("Redisson is not in Cluster mode");
        }
        return new RedissonReactiveRedisClusterConnection(((RedissonReactive)this.redisson.reactive()).getCommandExecutor());
    }
}

