/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import java.io.StringWriter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.revapi.java.compilation.CompilationValve;

public final class CompilationFuture
implements Future<Void> {
    private final CompilationValve valve;
    private final StringWriter output;

    public CompilationFuture(CompilationValve valve, StringWriter output) {
        this.valve = valve;
        this.output = output;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.valve.getCompilationResult().isDone() || this.valve.getEnvironment().getCompilationProgressLatch().getCount() == 0L;
    }

    @Override
    public Void get() throws InterruptedException, ExecutionException {
        this.valve.getEnvironment().getCompilationProgressLatch().await();
        if (this.valve.getCompilationResult().isDone()) {
            this.valve.getCompilationResult().get();
            return null;
        }
        if (this.output.getBuffer().length() > 0) {
            throw new ExecutionException(new Exception("Compilation failed while analyzing " + this.valve.getEnvironment().getApi() + ":\n" + this.output.toString()));
        }
        return null;
    }

    @Override
    public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.valve.getEnvironment().getCompilationProgressLatch().await(timeout, unit)) {
            throw new TimeoutException();
        }
        if (this.valve.getCompilationResult().isDone()) {
            this.valve.getCompilationResult().get();
            return null;
        }
        if (this.output.getBuffer().length() > 0) {
            throw new ExecutionException(new Exception("Compilation failed while analyzing " + this.valve.getEnvironment().getApi() + ":\n" + this.output.toString()));
        }
        return null;
    }
}

