/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb.util;

public class Environment {
    private static String OS = System.getProperty("os.name").toLowerCase();
    private static String ARCH = System.getProperty("os.arch").toLowerCase();

    public static boolean isAarch64() {
        return ARCH.contains("aarch64");
    }

    public static boolean isPowerPC() {
        return ARCH.contains("ppc");
    }

    public static boolean isS390x() {
        return ARCH.contains("s390x");
    }

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isFreeBSD() {
        return OS.contains("freebsd");
    }

    public static boolean isMac() {
        return OS.contains("mac");
    }

    public static boolean isAix() {
        return OS.contains("aix");
    }

    public static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux");
    }

    public static boolean isSolaris() {
        return OS.contains("sunos");
    }

    public static boolean isOpenBSD() {
        return OS.contains("openbsd");
    }

    public static boolean is64Bit() {
        if (ARCH.indexOf("sparcv9") >= 0) {
            return true;
        }
        return ARCH.indexOf("64") > 0;
    }

    public static String getSharedLibraryName(String string) {
        return string + "jni";
    }

    public static String getSharedLibraryFileName(String string) {
        return Environment.appendLibOsSuffix("lib" + Environment.getSharedLibraryName(string), true);
    }

    public static String getJniLibraryName(String string) {
        if (Environment.isUnix()) {
            String string2;
            String string3 = string2 = Environment.is64Bit() ? "64" : "32";
            if (Environment.isPowerPC() || Environment.isAarch64()) {
                return String.format("%sjni-linux-%s", string, ARCH);
            }
            if (Environment.isS390x()) {
                return String.format("%sjni-linux%s", string, ARCH);
            }
            return String.format("%sjni-linux%s", string, string2);
        }
        if (Environment.isMac()) {
            return String.format("%sjni-osx", string);
        }
        if (Environment.isFreeBSD()) {
            return String.format("%sjni-freebsd%s", string, Environment.is64Bit() ? "64" : "32");
        }
        if (Environment.isAix() && Environment.is64Bit()) {
            return String.format("%sjni-aix64", string);
        }
        if (Environment.isSolaris()) {
            String string4 = Environment.is64Bit() ? "64" : "32";
            return String.format("%sjni-solaris%s", string, string4);
        }
        if (Environment.isWindows() && Environment.is64Bit()) {
            return String.format("%sjni-win64", string);
        }
        if (Environment.isOpenBSD()) {
            return String.format("%sjni-openbsd%s", string, Environment.is64Bit() ? "64" : "32");
        }
        throw new UnsupportedOperationException(String.format("Cannot determine JNI library name for ARCH='%s' OS='%s' name='%s'", ARCH, OS, string));
    }

    public static String getJniLibraryFileName(String string) {
        return Environment.appendLibOsSuffix("lib" + Environment.getJniLibraryName(string), false);
    }

    private static String appendLibOsSuffix(String string, boolean bl) {
        if (Environment.isUnix() || Environment.isAix() || Environment.isSolaris() || Environment.isFreeBSD() || Environment.isOpenBSD()) {
            return string + ".so";
        }
        if (Environment.isMac()) {
            return string + (bl ? ".dylib" : ".jnilib");
        }
        if (Environment.isWindows()) {
            return string + ".dll";
        }
        throw new UnsupportedOperationException();
    }

    public static String getJniLibraryExtension() {
        if (Environment.isWindows()) {
            return ".dll";
        }
        return Environment.isMac() ? ".jnilib" : ".so";
    }
}

