/*
 * Decompiled with CFR 0.152.
 */
package scala.runtime;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;

public final class ModuleSerializationProxy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> moduleClass;
    private static final ClassValue<Object> instances = new ClassValue<Object>(){

        @Override
        protected Object computeValue(Class<?> type) {
            try {
                return AccessController.doPrivileged(() -> type.getField("MODULE$").get(null));
            }
            catch (PrivilegedActionException e) {
                return ModuleSerializationProxy.rethrowRuntime(e.getCause());
            }
        }
    };

    private static Object rethrowRuntime(Throwable e) {
        Throwable cause = e.getCause();
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw new RuntimeException(cause);
    }

    public ModuleSerializationProxy(Class<?> moduleClass) {
        this.moduleClass = moduleClass;
    }

    private Object readResolve() {
        return instances.get(this.moduleClass);
    }
}

