/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chromium;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chromium.ChromiumDriver;
import org.openqa.selenium.chromium.HasLaunchApp;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AdditionalHttpCommands;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.http.HttpMethod;

@AutoService(value={AdditionalHttpCommands.class, AugmenterProvider.class})
public class AddHasLaunchApp
implements AugmenterProvider<HasLaunchApp>,
AdditionalHttpCommands {
    public static final String LAUNCH_APP = "launchApp";
    private static final Map<String, CommandInfo> COMMANDS = ImmutableMap.of((Object)"launchApp", (Object)new CommandInfo("/session/:sessionId/chromium/launch_app", HttpMethod.POST));

    public Map<String, CommandInfo> getAdditionalCommands() {
        return COMMANDS;
    }

    public Predicate<Capabilities> isApplicable() {
        return caps -> ChromiumDriver.IS_CHROMIUM_BROWSER.test(caps.getBrowserName());
    }

    public Class<HasLaunchApp> getDescribedInterface() {
        return HasLaunchApp.class;
    }

    public HasLaunchApp getImplementation(Capabilities capabilities, final ExecuteMethod executeMethod) {
        return new HasLaunchApp(){

            @Override
            public void launchApp(String id) {
                Require.nonNull((String)"id of Chromium App", (Object)id);
                executeMethod.execute(AddHasLaunchApp.LAUNCH_APP, (Map)ImmutableMap.of((Object)"id", (Object)id));
            }
        };
    }
}

