/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.log;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.bidi.log.GenericLogEntry;
import org.openqa.selenium.bidi.log.LogLevel;
import org.openqa.selenium.bidi.log.StackTrace;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class ConsoleLogEntry
extends GenericLogEntry {
    private final String method;
    private final String realm;
    private final List<Object> args;

    public ConsoleLogEntry(LogLevel level, String text, long timestamp, String type, String method, String realm, List<Object> args, StackTrace stackTrace) {
        super(level, text, timestamp, type, stackTrace);
        this.method = method;
        this.realm = realm;
        this.args = args;
    }

    public String getMethod() {
        return this.method;
    }

    public String getRealm() {
        return this.realm;
    }

    public List<Object> getArgs() {
        return this.args;
    }

    public static ConsoleLogEntry fromJson(JsonInput input) {
        LogLevel level = null;
        String text = null;
        long timestamp = 0L;
        String type = null;
        String method = null;
        String realm = null;
        List args = null;
        StackTrace stackTrace = null;
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "level": {
                    level = (LogLevel)((Object)input.read(LogLevel.class));
                    continue block20;
                }
                case "text": {
                    text = (String)input.read(String.class);
                    continue block20;
                }
                case "timestamp": {
                    timestamp = (Long)input.read(Long.class);
                    continue block20;
                }
                case "type": {
                    type = (String)input.read(String.class);
                    continue block20;
                }
                case "method": {
                    method = (String)input.read(String.class);
                    continue block20;
                }
                case "realm": {
                    realm = (String)input.read(String.class);
                    continue block20;
                }
                case "args": {
                    args = (List)input.read(new TypeToken<List<Object>>(){}.getType());
                    continue block20;
                }
                case "stackTrace": {
                    stackTrace = (StackTrace)input.read(StackTrace.class);
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ConsoleLogEntry(level, text, timestamp, type, method, realm, args, stackTrace);
    }

    private Map<String, Object> toJson() {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        toReturn.put("type", super.getType());
        toReturn.put("level", (Object)super.getLevel());
        toReturn.put("text", super.getText());
        toReturn.put("timestamp", super.getTimestamp());
        toReturn.put("method", this.method);
        toReturn.put("realm", this.realm);
        toReturn.put("args", this.args);
        toReturn.put("stackTrace", super.getStackTrace());
        return Collections.unmodifiableMap(toReturn);
    }
}

