/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import com.beust.jcommander.Parameter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.primitives.Primitives;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.config.ConfigValue;
import org.openqa.selenium.internal.Require;

public class AnnotatedConfig
implements Config {
    private final Map<String, Map<String, List<String>>> config;

    public AnnotatedConfig(Object obj) {
        this(obj, Collections.emptySet(), false);
    }

    /*
     * Unable to fully structure code
     */
    public AnnotatedConfig(Object obj, Set<String> cliArgs, boolean includeCliArgs) {
        super();
        values = new HashMap<String, Map<String, List<String>>>();
        allConfigValues = this.findConfigFields(obj.getClass());
        for (Field field : allConfigValues) {
            if (Map.class.isAssignableFrom(field.getType())) {
                throw new ConfigException("Map fields may not be used for configuration: " + field, new Object[0]);
            }
            field.setAccessible(true);
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new ConfigException("Unable to read field: " + field, new Object[0]);
            }
            annotation = field.getAnnotation(ConfigValue.class);
            cliAnnotation = field.getAnnotation(Parameter.class);
            if (cliAnnotation == null) ** GOTO lbl-1000
            if (Arrays.stream(cliAnnotation.names()).anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)(cliArgs))) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = containsCliArg = false;
            }
            if (cliArgs.size() > 0 && !containsCliArg && includeCliArgs || cliArgs.size() > 0 && containsCliArg && !includeCliArgs) continue;
            section = values.computeIfAbsent(annotation.section(), (Function<String, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$0(java.lang.String ), (Ljava/lang/String;)Ljava/util/Map;)());
            all = section.computeIfAbsent(annotation.name(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$1(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)());
            if (value instanceof Collection) {
                for (E o : (Collection)value) {
                    singleValue = this.getSingleValue(o);
                    if (singleValue == null) continue;
                    all.add(singleValue);
                }
                continue;
            }
            singleValue = this.getSingleValue(value);
            if (singleValue == null) continue;
            all.add(singleValue);
        }
        this.config = values;
    }

    private String getSingleValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            throw new ConfigException("Map fields may not be used for configuration: " + value, new Object[0]);
        }
        if (value instanceof Collection) {
            throw new ConfigException("Collection fields may not be used for configuration: " + value, new Object[0]);
        }
        if (Boolean.FALSE.equals(value) && !Primitives.isWrapperType(value.getClass())) {
            return null;
        }
        if (value instanceof Number && ((Number)value).floatValue() == 0.0f) {
            return null;
        }
        return String.valueOf(value);
    }

    private Deque<Field> findConfigFields(Class<?> clazz) {
        ArrayDeque<Field> toSet = new ArrayDeque<Field>();
        HashSet toVisit = new HashSet();
        toVisit.add(clazz);
        HashSet<Class> seen = new HashSet<Class>();
        while (!toVisit.isEmpty()) {
            clazz = (Class)toVisit.iterator().next();
            toVisit.remove(clazz);
            seen.add(clazz);
            Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.getAnnotation(ConfigValue.class) != null).forEach(toSet::addLast);
            Class toAdd = clazz.getSuperclass();
            if (toAdd != null && !Object.class.equals(toAdd) && !seen.contains(toAdd)) {
                toVisit.add(toAdd);
            }
            Arrays.stream(clazz.getInterfaces()).filter(face -> !seen.contains(face)).forEach(toVisit::add);
        }
        return toSet;
    }

    @Override
    public Optional<List<String>> getAll(String section, String option) {
        Require.nonNull((String)"Section name", (Object)section);
        Require.nonNull((String)"Option name", (Object)option);
        Map<String, List<String>> sec = this.config.get(section);
        if (sec == null || sec.isEmpty()) {
            return Optional.empty();
        }
        List<String> values = sec.get(option);
        if (values == null || values.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(ImmutableList.copyOf(values));
    }

    @Override
    public Set<String> getSectionNames() {
        return ImmutableSortedSet.copyOf(this.config.keySet());
    }

    @Override
    public Set<String> getOptions(String section) {
        Require.nonNull((String)"Section name to get options for", (Object)section);
        return ImmutableSortedSet.copyOf(this.config.getOrDefault(section, (Map<String, List<String>>)ImmutableMap.of()).keySet());
    }

    private static /* synthetic */ List lambda$new$1(String str) {
        return new LinkedList();
    }

    private static /* synthetic */ Map lambda$new$0(String str) {
        return new HashMap();
    }
}

