/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import org.sonarsource.scanner.api.Utils;
import org.sonarsource.scanner.api.internal.cache.Logger;

class Dirs {
    private final Logger logger;

    Dirs(Logger logger) {
        this.logger = logger;
    }

    void init(Map<String, String> p) {
        boolean onProject = Utils.taskRequiresProject(p);
        if (onProject) {
            this.initProjectDirs(p);
        } else {
            Dirs.initTaskDirs(p);
        }
    }

    private void initProjectDirs(Map<String, String> p) {
        Path workDirPath;
        String pathString = Optional.ofNullable(p.get("sonar.projectBaseDir")).orElse("");
        Path absoluteProjectPath = Paths.get(pathString, new String[0]).toAbsolutePath().normalize();
        if (!Files.isDirectory(absoluteProjectPath, new LinkOption[0])) {
            throw new IllegalStateException("Project home must be an existing directory: " + pathString);
        }
        p.put("sonar.projectBaseDir", absoluteProjectPath.toString());
        pathString = Optional.ofNullable(p.get("sonar.working.directory")).orElse("");
        if ("".equals(pathString.trim())) {
            workDirPath = absoluteProjectPath.resolve(".scannerwork");
        } else {
            workDirPath = Paths.get(pathString, new String[0]);
            if (!workDirPath.isAbsolute()) {
                workDirPath = absoluteProjectPath.resolve(pathString);
            }
        }
        p.put("sonar.working.directory", workDirPath.normalize().toString());
        this.logger.debug("Work directory: " + workDirPath.normalize().toString());
    }

    private static void initTaskDirs(Map<String, String> p) {
        String path = Optional.ofNullable(p.get("sonar.working.directory")).orElse(".");
        File workDir = new File(path);
        p.put("sonar.working.directory", workDir.getAbsolutePath());
    }
}

