/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api.internal;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import org.sonarsource.scanner.api.internal.Tls12Java7SocketFactory;
import org.sonarsource.scanner.api.internal.shaded.okhttp.ConnectionSpec;
import org.sonarsource.scanner.api.internal.shaded.okhttp.OkHttpClient;

public class OkHttpClientFactory {
    static final int CONNECT_TIMEOUT_MILLISECONDS = 5000;
    static final int READ_TIMEOUT_MILLISECONDS = 60000;

    private OkHttpClientFactory() {
    }

    public static OkHttpClient create() {
        return OkHttpClientFactory.create(new JavaVersion());
    }

    static OkHttpClient create(JavaVersion javaVersion) {
        OkHttpClient httpClient = new OkHttpClient();
        httpClient.setConnectTimeout(5000L, TimeUnit.MILLISECONDS);
        httpClient.setReadTimeout(60000L, TimeUnit.MILLISECONDS);
        ConnectionSpec tls = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).allEnabledTlsVersions().allEnabledCipherSuites().supportsTlsExtensions(true).build();
        httpClient.setConnectionSpecs(Arrays.asList(tls, ConnectionSpec.CLEARTEXT));
        httpClient.setSslSocketFactory(OkHttpClientFactory.createSslSocketFactory(javaVersion));
        return httpClient;
    }

    private static SSLSocketFactory createSslSocketFactory(JavaVersion javaVersion) {
        try {
            SSLSocketFactory sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            return OkHttpClientFactory.enableTls12InJava7(sslSocketFactory, javaVersion);
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to init TLS context", e);
        }
    }

    private static SSLSocketFactory enableTls12InJava7(SSLSocketFactory sslSocketFactory, JavaVersion javaVersion) {
        if (javaVersion.isJava7()) {
            return new Tls12Java7SocketFactory(sslSocketFactory);
        }
        return sslSocketFactory;
    }

    static class JavaVersion {
        JavaVersion() {
        }

        boolean isJava7() {
            return System.getProperty("java.version").startsWith("1.7.");
        }
    }
}

