/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api.internal;

import java.io.File;
import java.util.Collection;
import org.sonarsource.scanner.api.internal.cache.Logger;
import org.sonarsource.scanner.api.internal.shaded.commonsio.FileUtils;
import org.sonarsource.scanner.api.internal.shaded.commonsio.filefilter.AgeFileFilter;
import org.sonarsource.scanner.api.internal.shaded.commonsio.filefilter.AndFileFilter;
import org.sonarsource.scanner.api.internal.shaded.commonsio.filefilter.PrefixFileFilter;

class TempCleaning {
    static final int ONE_DAY_IN_MILLISECONDS = 86400000;
    final File tempDir;
    private final Logger logger;

    TempCleaning(Logger logger) {
        this(new File(System.getProperty("java.io.tmpdir")), logger);
    }

    TempCleaning(File tempDir, Logger logger) {
        this.logger = logger;
        this.tempDir = tempDir;
    }

    void clean() {
        this.logger.debug("Start temp cleaning...");
        long cutoff = System.currentTimeMillis() - 86400000L;
        Collection<File> files = FileUtils.listFiles(this.tempDir, new AndFileFilter(new PrefixFileFilter("sonar-runner-batch"), new AgeFileFilter(cutoff)), null);
        for (File file : files) {
            FileUtils.deleteQuietly(file);
        }
        this.logger.debug("Temp cleaning done");
    }
}

