/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven.bootstrap;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.StreamSupport;

public class SourceCollector
implements FileVisitor<Path> {
    private static final Set<String> EXCLUDED_DIRECTORIES = new HashSet<String>(Arrays.asList("bin", "build", "dist", "nbbuild", "nbdist", "out", "target", "tmp"));
    private static final Set<String> EXCLUDED_EXTENSIONS = new HashSet<String>(Arrays.asList("jar", "war", "class", "ear", "nar", "DS_Store", "zip", "7z", "rar", "gz", "tar", "xz", "log", "bak", "tmp", "swp", "iml", "ipr", "iws", "nib", "log", "java", "jav", "kt", "scala"));
    private final Set<Path> existingSources;
    private final Set<Path> directoriesToIgnore;
    private final Set<Path> collectedSources = new HashSet<Path>();

    public Set<Path> getCollectedSources() {
        return this.collectedSources;
    }

    public SourceCollector(Set<Path> existingSources, Set<Path> directoriesToIgnore) {
        this.existingSources = existingSources;
        this.directoriesToIgnore = directoriesToIgnore;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        if (SourceCollector.isHidden(path) || this.isExcludedDirectory(path) || this.isCoveredByExistingSources(path)) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    private static boolean isHidden(Path path) {
        return StreamSupport.stream(path.spliterator(), true).anyMatch(token -> token.toString().startsWith("."));
    }

    private boolean isExcludedDirectory(Path path) {
        String pathAsString = path.getFileName().toString().toLowerCase(Locale.ROOT);
        return EXCLUDED_DIRECTORIES.contains(pathAsString) || this.directoriesToIgnore.contains(path);
    }

    private boolean isCoveredByExistingSources(Path path) {
        return this.existingSources.contains(path);
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
        if (EXCLUDED_EXTENSIONS.stream().noneMatch(ext -> path.toString().endsWith((String)ext))) {
            if (this.existingSources.stream().noneMatch(path::equals)) {
                this.collectedSources.add(path);
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path path, IOException e) throws IOException {
        return null;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException e) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

