/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven.bootstrap;

import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.sonarsource.scanner.api.EmbeddedScanner;
import org.sonarsource.scanner.api.LogOutput;
import org.sonarsource.scanner.maven.bootstrap.PropertyDecryptor;

public class ScannerFactory {
    private final LogOutput logOutput;
    private final RuntimeInformation runtimeInformation;
    private final MavenSession session;
    private final boolean debugEnabled;
    private final PropertyDecryptor propertyDecryptor;
    private final Properties envProps;

    public ScannerFactory(LogOutput logOutput, boolean debugEnabled, RuntimeInformation runtimeInformation, MavenSession session, Properties envProps, PropertyDecryptor propertyDecryptor) {
        this.logOutput = logOutput;
        this.runtimeInformation = runtimeInformation;
        this.session = session;
        this.debugEnabled = debugEnabled;
        this.envProps = envProps;
        this.propertyDecryptor = propertyDecryptor;
    }

    public EmbeddedScanner create() {
        EmbeddedScanner scanner = EmbeddedScanner.create((LogOutput)this.logOutput);
        scanner.setApp("Maven", this.runtimeInformation.getMavenVersion());
        scanner.addGlobalProperties(this.createGlobalProperties());
        scanner.setGlobalProperty("sonar.mojoUseRunner", "true");
        if (this.debugEnabled) {
            scanner.setGlobalProperty("sonar.verbose", "true");
        }
        return scanner;
    }

    public Properties createGlobalProperties() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.session.getCurrentProject().getProperties());
        p.putAll((Map<?, ?>)this.envProps);
        p.putAll((Map<?, ?>)this.session.getSystemProperties());
        p.putAll((Map<?, ?>)this.session.getUserProperties());
        p.putAll((Map<?, ?>)this.propertyDecryptor.decryptProperties(p));
        return p;
    }
}

