/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pyro.serializer;

import java.io.IOException;
import java.util.Map;
import net.razorvine.pyro.Config;
import net.razorvine.pyro.PyroException;
import net.razorvine.pyro.PyroProxy;
import net.razorvine.pyro.PyroURI;
import net.razorvine.pyro.serializer.PyroExceptionSerpent;
import net.razorvine.pyro.serializer.PyroProxySerpent;
import net.razorvine.pyro.serializer.PyroSerializer;
import net.razorvine.pyro.serializer.PyroUriSerpent;
import net.razorvine.serpent.IClassSerializer;
import net.razorvine.serpent.IDictToInstance;
import net.razorvine.serpent.Parser;
import net.razorvine.serpent.Serializer;
import net.razorvine.serpent.ast.Ast;

public class SerpentSerializer
extends PyroSerializer {
    @Override
    public int getSerializerId() {
        return 1;
    }

    @Override
    public byte[] serializeCall(String string, String string2, Object[] objectArray, Map<String, Object> map) throws IOException {
        Serializer serializer = new Serializer(Config.SERPENT_INDENT, Config.SERPENT_SET_LITERALS);
        Object[] objectArray2 = new Object[]{string, string2, objectArray, map};
        return serializer.serialize((Object)objectArray2);
    }

    @Override
    public byte[] serializeData(Object object) throws IOException {
        Serializer serializer = new Serializer(Config.SERPENT_INDENT, Config.SERPENT_SET_LITERALS);
        return serializer.serialize(object);
    }

    @Override
    public Object deserializeData(byte[] byArray) throws IOException {
        Parser parser = new Parser();
        Ast ast = parser.parse(byArray);
        DictConverter dictConverter = new DictConverter();
        return ast.getData((IDictToInstance)dictConverter);
    }

    static {
        Serializer.registerClass(PyroURI.class, (IClassSerializer)new PyroUriSerpent());
        Serializer.registerClass(PyroException.class, (IClassSerializer)new PyroExceptionSerpent());
        Serializer.registerClass(PyroProxy.class, (IClassSerializer)new PyroProxySerpent());
    }

    class DictConverter
    implements IDictToInstance {
        DictConverter() {
        }

        public Object convert(Map<Object, Object> map) throws IOException {
            boolean bl;
            String string = (String)map.get("__class__");
            boolean bl2 = bl = map.containsKey("__exception__") && (Boolean)map.get("__exception__") != false;
            if (bl) {
                return PyroExceptionSerpent.FromSerpentDict(map);
            }
            if ("Pyro4.core.URI".equals(string)) {
                return PyroUriSerpent.FromSerpentDict(map);
            }
            if ("Pyro4.core.Proxy".equals(string)) {
                return PyroProxySerpent.FromSerpentDict(map);
            }
            return null;
        }
    }
}

