/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring.mock;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.spockframework.runtime.SpecInfoBuilder;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.spring.SpringBean;
import org.spockframework.spring.SpringSpy;
import org.spockframework.spring.StubBeans;
import org.spockframework.spring.mock.Definition;
import org.spockframework.spring.mock.SpockDefinition;
import org.spockframework.spring.mock.SpyDefinition;
import org.spockframework.spring.mock.StubDefinition;
import org.spockframework.util.ReflectionUtil;
import spock.lang.Specification;

class DefinitionsParser {
    private Set<Definition> definitions = new LinkedHashSet<Definition>();

    DefinitionsParser() {
    }

    void parse(Object object) {
        if (object instanceof Class) {
            Class clazz = (Class)object;
            if (Specification.class.isAssignableFrom(clazz)) {
                this.inspect(clazz);
            }
        } else if (object instanceof Specification) {
            this.inspect(object.getClass());
        }
    }

    private void inspect(Class<?> clazz) {
        List stubBeans = ReflectionUtil.collectAnnotationRecursive(clazz, StubBeans.class);
        for (StubBeans stubBean : stubBeans) {
            for (Class<?> stub : stubBean.value()) {
                this.definitions.add(new StubDefinition(stub));
            }
            if (stubBean.inherit()) continue;
            break;
        }
        SpecInfo specInfo = new SpecInfoBuilder(clazz).build();
        List fields = specInfo.getAllFields();
        for (FieldInfo field : fields) {
            if (field.isAnnotationPresent(SpringBean.class)) {
                this.definitions.add(new SpockDefinition(field));
                continue;
            }
            if (!field.isAnnotationPresent(SpringSpy.class)) continue;
            this.definitions.add(new SpyDefinition(field));
        }
    }

    Set<Definition> getDefinitions() {
        return this.definitions;
    }
}

