package spring.boot.shiro;

import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import spring.boot.shiro.service.AccountService;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BaseFormAuthenticationFilter extends FormAuthenticationFilter {
	private static final Logger _logger = LoggerFactory.getLogger(BaseFormAuthenticationFilter.class);

	@Autowired
	private AccountService accountService;

	/**
	 * 覆盖默认实现，用sendRedirect直接跳出框架，以免造成js框架重复加载js出错。
	 * @param token
	 * @param subject
	 * @param request
	 * @param response
	 * @return
	 * @throws Exception
	 * @see FormAuthenticationFilter#onLoginSuccess(AuthenticationToken, Subject, javax.servlet.ServletRequest, javax.servlet.ServletResponse)
	 */
	@Override
    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject,
            ServletRequest request, ServletResponse response) throws Exception {
		//issueSuccessRedirect(request, response);
		//we handled the success redirect directly, prevent the chain from continuing:
		HttpServletRequest httpServletRequest = (HttpServletRequest)request;
		HttpServletResponse httpServletResponse = (HttpServletResponse)response;

		try {
			accountService.saveLoginHis(token, subject, (HttpServletRequest) request);
		} catch (Exception e) {
			e.printStackTrace();
		}
		if (!"XMLHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("X-Requested-With"))) {// 不是ajax请求
			//httpServletResponse.sendRedirect(httpServletRequest.getContextPath() + this.getSuccessUrl());
			return super.onLoginSuccess(token, subject, request, response);
		} else {
			httpServletRequest.getRequestDispatcher(ajaxLoginSuccessUrl).forward(httpServletRequest, httpServletResponse);
		}
		return false;
	}

	private String ajaxLoginSuccessUrl = "/login/ajax/success";

	public String getAjaxLoginSuccessUrl() {
		return ajaxLoginSuccessUrl;
	}

	public void setAjaxLoginSuccessUrl(String ajaxLoginSuccessUrl) {
		this.ajaxLoginSuccessUrl = ajaxLoginSuccessUrl;
	}

	public AccountService getAccountService() {
		return accountService;
	}

	public void setAccountService(AccountService accountService) {
		this.accountService = accountService;
	}

	@Override
	protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
		accountService.saveLoginHis(token, null, (HttpServletRequest) request);
		return super.onLoginFailure(token, e, request, response);
	}
}
