package spring.boot.shiro;


import org.apache.shiro.config.Ini;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.web.config.IniFilterChainResolverFactory;
import org.springframework.beans.factory.FactoryBean;
import spring.boot.shiro.service.ResourceService;
import spring.boot.shiro.vo.Resource;

import java.util.List;

/**
 * Created by xiaoqian on 2015/11/18.
 * 权限配置可以放到数据库中
 */
public class ChainDefinitionSectionMetaSource implements FactoryBean<Ini.Section> {

    ResourceService resourceService;

    public void setResourceService(ResourceService resourceService){
        this.resourceService = resourceService;
    }

    private String filterChainDefinitions;

    public void setFilterChainDefinitions(String filterChainDefinitions) {
        this.filterChainDefinitions = filterChainDefinitions;
    }

    @Override
    public Ini.Section getObject() throws Exception {
        Ini ini = new Ini();
        ini.load(filterChainDefinitions);
        Ini.Section section = ini.getSection(IniFilterChainResolverFactory.URLS);
        if (CollectionUtils.isEmpty(section)) {
            section = ini.getSection(Ini.DEFAULT_SECTION_NAME);
        }
        List<Resource> resources = resourceService.getAllValidResource();
        for (Resource resource : resources) {
            section.put(resource.getUrl(), resource.getPermExp());
        }
        return section;
    }

    @Override
    public Class<?> getObjectType() {
        return Ini.Section.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}
