/*
 * Decompiled with CFR 0.152.
 */
package spring.boot.shiro;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import spring.boot.shiro.service.AccountService;

public class BaseFormAuthenticationFilter
extends FormAuthenticationFilter {
    private static final Logger _logger = LoggerFactory.getLogger(BaseFormAuthenticationFilter.class);
    @Autowired
    private AccountService accountService;
    private String ajaxLoginSuccessUrl = "/login/ajax/success";

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        try {
            this.accountService.saveLoginHis(token, subject, (HttpServletRequest)request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!"XMLHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("X-Requested-With"))) {
            return super.onLoginSuccess(token, subject, request, response);
        }
        httpServletRequest.getRequestDispatcher(this.ajaxLoginSuccessUrl).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        return false;
    }

    public String getAjaxLoginSuccessUrl() {
        return this.ajaxLoginSuccessUrl;
    }

    public void setAjaxLoginSuccessUrl(String ajaxLoginSuccessUrl) {
        this.ajaxLoginSuccessUrl = ajaxLoginSuccessUrl;
    }

    public AccountService getAccountService() {
        return this.accountService;
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        this.accountService.saveLoginHis(token, null, (HttpServletRequest)request);
        return super.onLoginFailure(token, e, request, response);
    }
}

