/*
 * Decompiled with CFR 0.152.
 */
package spring.boot.shiro;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.util.WebUtils;
import spring.boot.shiro.BaseFormAuthenticationFilter;
import spring.boot.shiro.CaptchaUsernamePasswordToken;

public class CaptchaFormAuthenticationFilter
extends BaseFormAuthenticationFilter {
    private String captchaParam = "captcha_key";

    public void setCaptchaParam(String captchaParam) {
        this.captchaParam = captchaParam;
    }

    public String getCaptchaParam() {
        return this.captchaParam;
    }

    protected String getCaptcha(ServletRequest request) {
        return WebUtils.getCleanParam((ServletRequest)request, (String)this.getCaptchaParam());
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        String username = this.getUsername(request);
        String password = this.getPassword(request);
        String captcha = this.getCaptcha(request);
        boolean rememberMe = this.isRememberMe(request);
        String host = this.getHost(request);
        return new CaptchaUsernamePasswordToken(username, password, rememberMe, host, captcha);
    }
}

