/*
 * Decompiled with CFR 0.152.
 */
package spring.boot.shiro;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.session.Session;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.apache.shiro.web.util.WebUtils;

public class ForceLogoutFilter
extends AccessControlFilter {
    public static final String SESSION_FORCE_LOGOUT_KEY = "SESSION_FORCE_LOGOUT_KEY";

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        Session session = this.getSubject(request, response).getSession(false);
        if (session == null) {
            return true;
        }
        return session.getAttribute((Object)SESSION_FORCE_LOGOUT_KEY) == null;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        try {
            this.getSubject(request, response).logout();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String loginUrl = this.getLoginUrl() + (this.getLoginUrl().contains("?") ? "&" : "?") + "forceLogout=1";
        WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)loginUrl);
        return false;
    }
}

