/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.boot.file;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.springblade.core.boot.file.BladeFile;
import org.springblade.core.tool.utils.StringUtil;
import org.springframework.web.multipart.MultipartFile;

public class BladeFileUtil {
    private static HashMap<String, String> extMap = new HashMap();
    private static String IS_DIR = "is_dir";
    private static String FILE_NAME = "filename";
    private static String FILE_SIZE = "filesize";
    private static String[] fileTypes = new String[]{"gif", "jpg", "jpeg", "png", "bmp"};

    public static String getFileExt(String fileName) {
        return fileName.substring(fileName.lastIndexOf("."));
    }

    public static boolean testExt(String dir, String fileName) {
        String fileExt = BladeFileUtil.getFileExt(fileName);
        String ext = extMap.get(dir);
        return !StringUtil.isBlank((CharSequence)ext) && ext.indexOf(fileExt) != -1;
    }

    public static String formatUrl(String url) {
        return url.replaceAll("\\\\", "/");
    }

    public static BladeFile getFile(MultipartFile file) {
        return BladeFileUtil.getFile(file, "image", null, null);
    }

    public static BladeFile getFile(MultipartFile file, String dir) {
        return BladeFileUtil.getFile(file, dir, null, null);
    }

    public static BladeFile getFile(MultipartFile file, String dir, String path, String virtualPath) {
        return new BladeFile(file, dir, path, virtualPath);
    }

    public static List<BladeFile> getFiles(List<MultipartFile> files) {
        return BladeFileUtil.getFiles(files, "image", null, null);
    }

    public static List<BladeFile> getFiles(List<MultipartFile> files, String dir) {
        return BladeFileUtil.getFiles(files, dir, null, null);
    }

    public static List<BladeFile> getFiles(List<MultipartFile> files, String dir, String path, String virtualPath) {
        ArrayList<BladeFile> list = new ArrayList<BladeFile>();
        for (MultipartFile file : files) {
            list.add(new BladeFile(file, dir, path, virtualPath));
        }
        return list;
    }

    static {
        extMap.put("image", ".gif,.jpg,.jpeg,.png,.bmp,.JPG,.JPEG,.PNG");
        extMap.put("flash", ".swf,.flv");
        extMap.put("media", ".swf,.flv,.mp3,.mp4,.wav,.wma,.wmv,.mid,.avi,.mpg,.asf,.rm,.rmvb");
        extMap.put("file", ".doc,.docx,.xls,.xlsx,.ppt,.htm,.html,.txt,.zip,.rar,.gz,.bz2");
        extMap.put("allfile", ".gif,.jpg,.jpeg,.png,.bmp,.swf,.flv,.mp3,.mp4,.wav,.wma,.wmv,.mid,.avi,.mpg,.asf,.rm,.rmvb,.doc,.docx,.xls,.xlsx,.ppt,.htm,.html,.txt,.zip,.rar,.gz,.bz2");
    }

    public static class TypeComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            Hashtable hashA = (Hashtable)a;
            Hashtable hashB = (Hashtable)b;
            if (((Boolean)hashA.get(IS_DIR)).booleanValue() && !((Boolean)hashB.get(IS_DIR)).booleanValue()) {
                return -1;
            }
            if (!((Boolean)hashA.get(IS_DIR)).booleanValue() && ((Boolean)hashB.get(IS_DIR)).booleanValue()) {
                return 1;
            }
            return ((String)hashA.get("filetype")).compareTo((String)hashB.get("filetype"));
        }
    }

    public static class SizeComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            Hashtable hashA = (Hashtable)a;
            Hashtable hashB = (Hashtable)b;
            if (((Boolean)hashA.get(IS_DIR)).booleanValue() && !((Boolean)hashB.get(IS_DIR)).booleanValue()) {
                return -1;
            }
            if (!((Boolean)hashA.get(IS_DIR)).booleanValue() && ((Boolean)hashB.get(IS_DIR)).booleanValue()) {
                return 1;
            }
            if ((Long)hashA.get(FILE_SIZE) > (Long)hashB.get(FILE_SIZE)) {
                return 1;
            }
            if ((Long)hashA.get(FILE_SIZE) < (Long)hashB.get(FILE_SIZE)) {
                return -1;
            }
            return 0;
        }
    }

    public static class NameComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            Hashtable hashA = (Hashtable)a;
            Hashtable hashB = (Hashtable)b;
            if (((Boolean)hashA.get(IS_DIR)).booleanValue() && !((Boolean)hashB.get(IS_DIR)).booleanValue()) {
                return -1;
            }
            if (!((Boolean)hashA.get(IS_DIR)).booleanValue() && ((Boolean)hashB.get(IS_DIR)).booleanValue()) {
                return 1;
            }
            return ((String)hashA.get(FILE_NAME)).compareTo((String)hashB.get(FILE_NAME));
        }
    }

    public static enum FileSort {
        size,
        type,
        name;


        public static FileSort of(String sort) {
            try {
                return FileSort.valueOf(sort);
            }
            catch (Exception e) {
                return name;
            }
        }
    }
}

