/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.develop.support;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.converts.MySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.OracleTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.PostgreSqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.SqlServerTypeConvert;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.StringUtil;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class BladeCodeGenerator {
    private static final Logger log = LoggerFactory.getLogger(BladeCodeGenerator.class);
    private String systemName = "sword";
    private String codeName;
    private String serviceName = "blade-service";
    private String packageName = "org.springblade.test";
    private String packageDir;
    private String packageWebDir;
    private String[] tablePrefix = new String[]{"blade_"};
    private String[] includeTables = new String[]{"blade_test"};
    private String[] excludeTables = new String[0];
    private Boolean hasSuperEntity = Boolean.FALSE;
    private Boolean hasWrapper = Boolean.FALSE;
    private String[] superEntityColumns = new String[]{"create_time", "create_user", "create_dept", "update_time", "update_user", "status", "is_deleted"};
    private String tenantColumn = "tenant_id";
    private Boolean isSwagger2 = Boolean.TRUE;
    private String driverName;
    private String url;
    private String username;
    private String password;

    public void run() {
        Properties props = this.getProperties();
        AutoGenerator mpg = new AutoGenerator();
        GlobalConfig gc = new GlobalConfig();
        String outputDir = this.getOutputDir();
        String author = props.getProperty("author");
        gc.setOutputDir(outputDir);
        gc.setAuthor(author);
        gc.setFileOverride(true);
        gc.setOpen(false);
        gc.setActiveRecord(false);
        gc.setEnableCache(false);
        gc.setBaseResultMap(true);
        gc.setBaseColumnList(true);
        gc.setMapperName("%sMapper");
        gc.setXmlName("%sMapper");
        gc.setServiceName("I%sService");
        gc.setServiceImplName("%sServiceImpl");
        gc.setControllerName("%sController");
        gc.setSwagger2(this.isSwagger2.booleanValue());
        mpg.setGlobalConfig(gc);
        DataSourceConfig dsc = new DataSourceConfig();
        String driverName = Func.toStr((Object)this.driverName, (String)props.getProperty("spring.datasource.driver-class-name"));
        if (StringUtil.containsAny((CharSequence)driverName, (CharSequence[])new CharSequence[]{DbType.MYSQL.getDb()})) {
            dsc.setDbType(DbType.MYSQL);
            dsc.setTypeConvert((ITypeConvert)new MySqlTypeConvert());
        } else if (StringUtil.containsAny((CharSequence)driverName, (CharSequence[])new CharSequence[]{DbType.POSTGRE_SQL.getDb()})) {
            dsc.setDbType(DbType.POSTGRE_SQL);
            dsc.setTypeConvert((ITypeConvert)new PostgreSqlTypeConvert());
        } else if (StringUtil.containsAny((CharSequence)driverName, (CharSequence[])new CharSequence[]{DbType.SQL_SERVER.getDb()})) {
            dsc.setDbType(DbType.SQL_SERVER);
            dsc.setTypeConvert((ITypeConvert)new SqlServerTypeConvert());
        } else {
            dsc.setDbType(DbType.ORACLE);
            dsc.setTypeConvert((ITypeConvert)new OracleTypeConvert());
        }
        dsc.setDriverName(driverName);
        dsc.setUrl(Func.toStr((Object)this.url, (String)props.getProperty("spring.datasource.url")));
        dsc.setUsername(Func.toStr((Object)this.username, (String)props.getProperty("spring.datasource.username")));
        dsc.setPassword(Func.toStr((Object)this.password, (String)props.getProperty("spring.datasource.password")));
        mpg.setDataSource(dsc);
        StrategyConfig strategy = new StrategyConfig();
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        strategy.setTablePrefix(this.tablePrefix);
        if (this.includeTables.length > 0) {
            strategy.setInclude(this.includeTables);
        }
        if (this.excludeTables.length > 0) {
            strategy.setExclude(this.excludeTables);
        }
        if (this.hasSuperEntity.booleanValue()) {
            strategy.setSuperEntityClass("org.springblade.core.mp.base.BaseEntity");
            strategy.setSuperEntityColumns(this.superEntityColumns);
            strategy.setSuperServiceClass("org.springblade.core.mp.base.BaseService");
            strategy.setSuperServiceImplClass("org.springblade.core.mp.base.BaseServiceImpl");
        } else {
            strategy.setSuperServiceClass("com.baomidou.mybatisplus.extension.service.IService");
            strategy.setSuperServiceImplClass("com.baomidou.mybatisplus.extension.service.impl.ServiceImpl");
        }
        strategy.setSuperControllerClass("org.springblade.core.boot.ctrl.BladeController");
        strategy.setEntityBuilderModel(false);
        strategy.setEntityLombokModel(true);
        strategy.setControllerMappingHyphenStyle(true);
        mpg.setStrategy(strategy);
        PackageConfig pc = new PackageConfig();
        pc.setModuleName(null);
        pc.setParent(this.packageName);
        pc.setController("controller");
        pc.setEntity("entity");
        pc.setXml("mapper");
        mpg.setPackageInfo(pc);
        mpg.setCfg(this.getInjectionConfig());
        mpg.execute();
    }

    private InjectionConfig getInjectionConfig() {
        final String servicePackage = this.serviceName.split("-").length > 1 ? this.serviceName.split("-")[1] : this.serviceName;
        final HashMap map = new HashMap(16);
        InjectionConfig cfg = new InjectionConfig(){

            public void initMap() {
                map.put("codeName", BladeCodeGenerator.this.codeName);
                map.put("serviceName", BladeCodeGenerator.this.serviceName);
                map.put("servicePackage", servicePackage);
                map.put("servicePackageLowerCase", servicePackage.toLowerCase());
                map.put("tenantColumn", BladeCodeGenerator.this.tenantColumn);
                map.put("hasWrapper", BladeCodeGenerator.this.hasWrapper);
                this.setMap(map);
            }
        };
        ArrayList<FileOutConfig> focList = new ArrayList<FileOutConfig>();
        focList.add(new FileOutConfig("/templates/sql/menu.sql.vm"){

            public String outputFile(TableInfo tableInfo) {
                map.put("entityKey", tableInfo.getEntityName().toLowerCase());
                map.put("menuId", IdWorker.getId());
                map.put("addMenuId", IdWorker.getId());
                map.put("editMenuId", IdWorker.getId());
                map.put("removeMenuId", IdWorker.getId());
                map.put("viewMenuId", IdWorker.getId());
                return BladeCodeGenerator.this.getOutputDir() + "//sql/" + tableInfo.getEntityName().toLowerCase() + ".menu.mysql";
            }
        });
        focList.add(new FileOutConfig("/templates/entityVO.java.vm"){

            public String outputFile(TableInfo tableInfo) {
                return BladeCodeGenerator.this.getOutputDir() + "/" + BladeCodeGenerator.this.packageName.replace(".", "/") + "/vo/" + tableInfo.getEntityName() + "VO" + ".java";
            }
        });
        focList.add(new FileOutConfig("/templates/entityDTO.java.vm"){

            public String outputFile(TableInfo tableInfo) {
                return BladeCodeGenerator.this.getOutputDir() + "/" + BladeCodeGenerator.this.packageName.replace(".", "/") + "/dto/" + tableInfo.getEntityName() + "DTO" + ".java";
            }
        });
        if (this.hasWrapper.booleanValue()) {
            focList.add(new FileOutConfig("/templates/wrapper.java.vm"){

                public String outputFile(TableInfo tableInfo) {
                    return BladeCodeGenerator.this.getOutputDir() + "/" + BladeCodeGenerator.this.packageName.replace(".", "/") + "/wrapper/" + tableInfo.getEntityName() + "Wrapper" + ".java";
                }
            });
        }
        if (Func.isNotBlank((CharSequence)this.packageWebDir)) {
            if (Func.equals((Object)this.systemName, (Object)"sword")) {
                focList.add(new FileOutConfig("/templates/sword/action.js.vm"){

                    public String outputFile(TableInfo tableInfo) {
                        return BladeCodeGenerator.this.getOutputWebDir() + "/actions/" + tableInfo.getEntityName().toLowerCase() + ".js";
                    }
                });
                focList.add(new FileOutConfig("/templates/sword/model.js.vm"){

                    public String outputFile(TableInfo tableInfo) {
                        return BladeCodeGenerator.this.getOutputWebDir() + "/models/" + tableInfo.getEntityName().toLowerCase() + ".js";
                    }
                });
                focList.add(new FileOutConfig("/templates/sword/service.js.vm"){

                    public String outputFile(TableInfo tableInfo) {
                        return BladeCodeGenerator.this.getOutputWebDir() + "/services/" + tableInfo.getEntityName().toLowerCase() + ".js";
                    }
                });
                focList.add(new FileOutConfig("/templates/sword/list.js.vm"){

                    public String outputFile(TableInfo tableInfo) {
                        return BladeCodeGenerator.this.getOutputWebDir() + "/pages/" + StringUtil.upperFirst((String)servicePackage) + "/" + tableInfo.getEntityName() + "/" + tableInfo.getEntityName() + ".js";
                    }
                });
                focList.add(new FileOutConfig("/templates/sword/add.js.vm"){

                    public String outputFile(TableInfo tableInfo) {
                        return BladeCodeGenerator.this.getOutputWebDir() + "/pages/" + StringUtil.upperFirst((String)servicePackage) + "/" + tableInfo.getEntityName() + "/" + tableInfo.getEntityName() + "Add.js";
                    }
                });
                focList.add(new FileOutConfig("/templates/sword/edit.js.vm"){

                    public String outputFile(TableInfo tableInfo) {
                        return BladeCodeGenerator.this.getOutputWebDir() + "/pages/" + StringUtil.upperFirst((String)servicePackage) + "/" + tableInfo.getEntityName() + "/" + tableInfo.getEntityName() + "Edit.js";
                    }
                });
                focList.add(new FileOutConfig("/templates/sword/view.js.vm"){

                    public String outputFile(TableInfo tableInfo) {
                        return BladeCodeGenerator.this.getOutputWebDir() + "/pages/" + StringUtil.upperFirst((String)servicePackage) + "/" + tableInfo.getEntityName() + "/" + tableInfo.getEntityName() + "View.js";
                    }
                });
            } else if (Func.equals((Object)this.systemName, (Object)"saber")) {
                focList.add(new FileOutConfig("/templates/saber/api.js.vm"){

                    public String outputFile(TableInfo tableInfo) {
                        return BladeCodeGenerator.this.getOutputWebDir() + "/api/" + servicePackage.toLowerCase() + "/" + tableInfo.getEntityName().toLowerCase() + ".js";
                    }
                });
                focList.add(new FileOutConfig("/templates/saber/crud.vue.vm"){

                    public String outputFile(TableInfo tableInfo) {
                        return BladeCodeGenerator.this.getOutputWebDir() + "/views/" + servicePackage.toLowerCase() + "/" + tableInfo.getEntityName().toLowerCase() + ".vue";
                    }
                });
            }
        }
        cfg.setFileOutConfigList(focList);
        return cfg;
    }

    private Properties getProperties() {
        ClassPathResource resource = new ClassPathResource("/templates/code.properties");
        Properties props = new Properties();
        try {
            props = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return props;
    }

    public String getOutputDir() {
        return (Func.isBlank((CharSequence)this.packageDir) ? System.getProperty("user.dir") + "/blade-ops/blade-develop" : this.packageDir) + "/src/main/java";
    }

    public String getOutputWebDir() {
        return (Func.isBlank((CharSequence)this.packageWebDir) ? System.getProperty("user.dir") : this.packageWebDir) + "/src";
    }

    private String getGeneratorViewPath(String viewOutputDir, TableInfo tableInfo, String suffixPath) {
        String name = StringUtils.firstToLowerCase((String)tableInfo.getEntityName());
        String path = viewOutputDir + "/" + name + "/" + name + suffixPath;
        File viewDir = new File(path).getParentFile();
        if (!viewDir.exists()) {
            viewDir.mkdirs();
        }
        return path;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPackageDir() {
        return this.packageDir;
    }

    public String getPackageWebDir() {
        return this.packageWebDir;
    }

    public String[] getTablePrefix() {
        return this.tablePrefix;
    }

    public String[] getIncludeTables() {
        return this.includeTables;
    }

    public String[] getExcludeTables() {
        return this.excludeTables;
    }

    public Boolean getHasSuperEntity() {
        return this.hasSuperEntity;
    }

    public Boolean getHasWrapper() {
        return this.hasWrapper;
    }

    public String[] getSuperEntityColumns() {
        return this.superEntityColumns;
    }

    public String getTenantColumn() {
        return this.tenantColumn;
    }

    public Boolean getIsSwagger2() {
        return this.isSwagger2;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public void setCodeName(String codeName) {
        this.codeName = codeName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageDir(String packageDir) {
        this.packageDir = packageDir;
    }

    public void setPackageWebDir(String packageWebDir) {
        this.packageWebDir = packageWebDir;
    }

    public void setTablePrefix(String[] tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setIncludeTables(String[] includeTables) {
        this.includeTables = includeTables;
    }

    public void setExcludeTables(String[] excludeTables) {
        this.excludeTables = excludeTables;
    }

    public void setHasSuperEntity(Boolean hasSuperEntity) {
        this.hasSuperEntity = hasSuperEntity;
    }

    public void setHasWrapper(Boolean hasWrapper) {
        this.hasWrapper = hasWrapper;
    }

    public void setSuperEntityColumns(String[] superEntityColumns) {
        this.superEntityColumns = superEntityColumns;
    }

    public void setTenantColumn(String tenantColumn) {
        this.tenantColumn = tenantColumn;
    }

    public void setIsSwagger2(Boolean isSwagger2) {
        this.isSwagger2 = isSwagger2;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BladeCodeGenerator)) {
            return false;
        }
        BladeCodeGenerator other = (BladeCodeGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$hasSuperEntity = this.getHasSuperEntity();
        Boolean other$hasSuperEntity = other.getHasSuperEntity();
        if (this$hasSuperEntity == null ? other$hasSuperEntity != null : !((Object)this$hasSuperEntity).equals(other$hasSuperEntity)) {
            return false;
        }
        Boolean this$hasWrapper = this.getHasWrapper();
        Boolean other$hasWrapper = other.getHasWrapper();
        if (this$hasWrapper == null ? other$hasWrapper != null : !((Object)this$hasWrapper).equals(other$hasWrapper)) {
            return false;
        }
        Boolean this$isSwagger2 = this.getIsSwagger2();
        Boolean other$isSwagger2 = other.getIsSwagger2();
        if (this$isSwagger2 == null ? other$isSwagger2 != null : !((Object)this$isSwagger2).equals(other$isSwagger2)) {
            return false;
        }
        String this$systemName = this.getSystemName();
        String other$systemName = other.getSystemName();
        if (this$systemName == null ? other$systemName != null : !this$systemName.equals(other$systemName)) {
            return false;
        }
        String this$codeName = this.getCodeName();
        String other$codeName = other.getCodeName();
        if (this$codeName == null ? other$codeName != null : !this$codeName.equals(other$codeName)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        String this$packageDir = this.getPackageDir();
        String other$packageDir = other.getPackageDir();
        if (this$packageDir == null ? other$packageDir != null : !this$packageDir.equals(other$packageDir)) {
            return false;
        }
        String this$packageWebDir = this.getPackageWebDir();
        String other$packageWebDir = other.getPackageWebDir();
        if (this$packageWebDir == null ? other$packageWebDir != null : !this$packageWebDir.equals(other$packageWebDir)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTablePrefix(), other.getTablePrefix())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getIncludeTables(), other.getIncludeTables())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getExcludeTables(), other.getExcludeTables())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSuperEntityColumns(), other.getSuperEntityColumns())) {
            return false;
        }
        String this$tenantColumn = this.getTenantColumn();
        String other$tenantColumn = other.getTenantColumn();
        if (this$tenantColumn == null ? other$tenantColumn != null : !this$tenantColumn.equals(other$tenantColumn)) {
            return false;
        }
        String this$driverName = this.getDriverName();
        String other$driverName = other.getDriverName();
        if (this$driverName == null ? other$driverName != null : !this$driverName.equals(other$driverName)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BladeCodeGenerator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $hasSuperEntity = this.getHasSuperEntity();
        result = result * 59 + ($hasSuperEntity == null ? 43 : ((Object)$hasSuperEntity).hashCode());
        Boolean $hasWrapper = this.getHasWrapper();
        result = result * 59 + ($hasWrapper == null ? 43 : ((Object)$hasWrapper).hashCode());
        Boolean $isSwagger2 = this.getIsSwagger2();
        result = result * 59 + ($isSwagger2 == null ? 43 : ((Object)$isSwagger2).hashCode());
        String $systemName = this.getSystemName();
        result = result * 59 + ($systemName == null ? 43 : $systemName.hashCode());
        String $codeName = this.getCodeName();
        result = result * 59 + ($codeName == null ? 43 : $codeName.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        String $packageDir = this.getPackageDir();
        result = result * 59 + ($packageDir == null ? 43 : $packageDir.hashCode());
        String $packageWebDir = this.getPackageWebDir();
        result = result * 59 + ($packageWebDir == null ? 43 : $packageWebDir.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTablePrefix());
        result = result * 59 + Arrays.deepHashCode(this.getIncludeTables());
        result = result * 59 + Arrays.deepHashCode(this.getExcludeTables());
        result = result * 59 + Arrays.deepHashCode(this.getSuperEntityColumns());
        String $tenantColumn = this.getTenantColumn();
        result = result * 59 + ($tenantColumn == null ? 43 : $tenantColumn.hashCode());
        String $driverName = this.getDriverName();
        result = result * 59 + ($driverName == null ? 43 : $driverName.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "BladeCodeGenerator(systemName=" + this.getSystemName() + ", codeName=" + this.getCodeName() + ", serviceName=" + this.getServiceName() + ", packageName=" + this.getPackageName() + ", packageDir=" + this.getPackageDir() + ", packageWebDir=" + this.getPackageWebDir() + ", tablePrefix=" + Arrays.deepToString(this.getTablePrefix()) + ", includeTables=" + Arrays.deepToString(this.getIncludeTables()) + ", excludeTables=" + Arrays.deepToString(this.getExcludeTables()) + ", hasSuperEntity=" + this.getHasSuperEntity() + ", hasWrapper=" + this.getHasWrapper() + ", superEntityColumns=" + Arrays.deepToString(this.getSuperEntityColumns()) + ", tenantColumn=" + this.getTenantColumn() + ", isSwagger2=" + this.getIsSwagger2() + ", driverName=" + this.getDriverName() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }
}

