/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.mp.config;

import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import org.mybatis.spring.annotation.MapperScan;
import org.springblade.core.mp.intercept.QueryInterceptor;
import org.springblade.core.mp.plugins.BladePaginationInterceptor;
import org.springblade.core.mp.plugins.SqlLogInterceptor;
import org.springblade.core.mp.props.MybatisPlusProperties;
import org.springblade.core.secure.utils.SecureUtil;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.ObjectUtil;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

@Configuration(proxyBeanMethods=false)
@MapperScan(value={"org.springblade.**.mapper.**"})
@EnableConfigurationProperties(value={MybatisPlusProperties.class})
public class MybatisPlusConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={TenantLineInnerInterceptor.class})
    public TenantLineInnerInterceptor tenantLineInnerInterceptor() {
        return new TenantLineInnerInterceptor(new TenantLineHandler(){

            public Expression getTenantId() {
                return new StringValue(Func.toStr((Object)SecureUtil.getTenantId(), (String)"000000"));
            }

            public boolean ignoreTable(String tableName) {
                return true;
            }
        });
    }

    @Bean
    @ConditionalOnMissingBean(value={MybatisPlusInterceptor.class})
    public MybatisPlusInterceptor mybatisPlusInterceptor(ObjectProvider<QueryInterceptor[]> queryInterceptors, TenantLineInnerInterceptor tenantLineInnerInterceptor, MybatisPlusProperties mybatisPlusProperties) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)tenantLineInnerInterceptor);
        BladePaginationInterceptor paginationInterceptor = new BladePaginationInterceptor();
        Object[] queryInterceptorArray = (QueryInterceptor[])queryInterceptors.getIfAvailable();
        if (ObjectUtil.isNotEmpty((Object)queryInterceptorArray)) {
            AnnotationAwareOrderComparator.sort((Object[])queryInterceptorArray);
            paginationInterceptor.setQueryInterceptors((QueryInterceptor[])queryInterceptorArray);
        }
        paginationInterceptor.setMaxLimit(mybatisPlusProperties.getPageLimit());
        paginationInterceptor.setOverflow(mybatisPlusProperties.getOverflow());
        interceptor.addInnerInterceptor((InnerInterceptor)paginationInterceptor);
        return interceptor;
    }

    @Bean
    @ConditionalOnProperty(value={"blade.mybatis-plus.sql-log"}, matchIfMissing=true)
    public SqlLogInterceptor sqlLogInterceptor() {
        return new SqlLogInterceptor();
    }
}

