/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.secure.auth;

import org.springblade.core.secure.utils.SecureUtil;
import org.springblade.core.tool.utils.CollectionUtil;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.StringUtil;

public class AuthFun {
    public boolean permitAll() {
        return true;
    }

    public boolean denyAll() {
        return this.hasRole("administrator");
    }

    public boolean hasRole(String role) {
        return this.hasAnyRole(role);
    }

    public boolean hasAnyRole(String ... role) {
        String userRole = SecureUtil.getUser().getRoleName();
        if (StringUtil.isBlank((CharSequence)userRole)) {
            return false;
        }
        Object[] roles = Func.toStrArray((String)userRole);
        for (String r : role) {
            if (!CollectionUtil.contains((Object[])roles, (Object)r)) continue;
            return true;
        }
        return false;
    }
}

