/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.support.xss;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springblade.core.tool.support.xss.XssHttpServletRequestWrapper;
import org.springblade.core.tool.support.xss.XssProperties;
import org.springblade.core.tool.support.xss.XssUrlProperties;
import org.springframework.util.AntPathMatcher;

public class XssFilter
implements Filter {
    private final XssProperties xssProperties;
    private final XssUrlProperties xssUrlProperties;
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();

    public void init(FilterConfig config) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String path = ((HttpServletRequest)request).getServletPath();
        if (this.isSkip(path)) {
            chain.doFilter(request, response);
        } else {
            XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest)request);
            chain.doFilter((ServletRequest)xssRequest, response);
        }
    }

    private boolean isSkip(String path) {
        return this.xssUrlProperties.getExcludePatterns().stream().anyMatch(pattern -> this.antPathMatcher.match(pattern, path)) || this.xssProperties.getSkipUrl().stream().anyMatch(pattern -> this.antPathMatcher.match(pattern, path));
    }

    public void destroy() {
    }

    public XssFilter(XssProperties xssProperties, XssUrlProperties xssUrlProperties) {
        this.xssProperties = xssProperties;
        this.xssUrlProperties = xssUrlProperties;
    }
}

