/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.springdoc.api.ErrorMessage;
import org.springdoc.api.OpenApiResourceNotFoundException;
import org.springdoc.core.CacheOrGroupedOpenApiCondition;
import org.springdoc.core.GenericParameterService;
import org.springdoc.core.GenericResponseService;
import org.springdoc.core.GroupedOpenApi;
import org.springdoc.core.MultipleOpenApiSupportCondition;
import org.springdoc.core.OpenAPIService;
import org.springdoc.core.OperationService;
import org.springdoc.core.PropertyResolverUtils;
import org.springdoc.core.RequestBodyService;
import org.springdoc.core.ReturnTypeParser;
import org.springdoc.core.SecurityService;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SpringDocProviders;
import org.springdoc.core.SpringDocUtils;
import org.springdoc.core.SpringdocActuatorBeanFactoryConfigurer;
import org.springdoc.core.SpringdocBeanFactoryConfigurer;
import org.springdoc.core.converters.AdditionalModelsConverter;
import org.springdoc.core.converters.FileSupportConverter;
import org.springdoc.core.converters.ModelConverterRegistrar;
import org.springdoc.core.converters.PageableOpenAPIConverter;
import org.springdoc.core.converters.PolymorphicModelConverter;
import org.springdoc.core.converters.PropertyCustomizingConverter;
import org.springdoc.core.converters.ResponseSupportConverter;
import org.springdoc.core.converters.SchemaPropertyDeprecatingConverter;
import org.springdoc.core.converters.models.Pageable;
import org.springdoc.core.customizers.ActuatorOpenApiCustomizer;
import org.springdoc.core.customizers.ActuatorOperationCustomizer;
import org.springdoc.core.customizers.DelegatingMethodParameterCustomizer;
import org.springdoc.core.customizers.OpenApiBuilderCustomizer;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.core.customizers.PropertyCustomizer;
import org.springdoc.core.providers.ActuatorProvider;
import org.springdoc.core.providers.CloudFunctionProvider;
import org.springdoc.core.providers.JavadocProvider;
import org.springdoc.core.providers.RepositoryRestResourceProvider;
import org.springdoc.core.providers.RouterFunctionProvider;
import org.springdoc.core.providers.SecurityOAuth2Provider;
import org.springdoc.core.providers.WebConversionServiceProvider;
import org.springdoc.core.providers.impl.SpringCloudFunctionProvider;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.format.WebConversionService;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.web.function.FunctionEndpointInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.data.domain.PageRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.async.DeferredResult;

@Lazy(value=false)
@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
@ConditionalOnWebApplication
public class SpringDocConfiguration {
    private static final String BINDRESULT_CLASS = "org.springframework.boot.context.properties.bind.BindResult";

    @Bean
    LocalVariableTableParameterNameDiscoverer localSpringDocParameterNameDiscoverer() {
        return new LocalVariableTableParameterNameDiscoverer();
    }

    @Bean
    @Lazy(value=false)
    AdditionalModelsConverter additionalModelsConverter() {
        return new AdditionalModelsConverter();
    }

    @Bean
    @Lazy(value=false)
    PropertyCustomizingConverter propertyCustomizingConverter(Optional<List<PropertyCustomizer>> customizers) {
        return new PropertyCustomizingConverter(customizers);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    FileSupportConverter fileSupportConverter() {
        return new FileSupportConverter();
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    ResponseSupportConverter responseSupportConverter() {
        return new ResponseSupportConverter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"springdoc.model-converters.deprecating-converter.enabled"}, matchIfMissing=true)
    @Lazy(value=false)
    SchemaPropertyDeprecatingConverter schemaPropertyDeprecatingConverter() {
        return new SchemaPropertyDeprecatingConverter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"springdoc.model-converters.polymorphic-converter.enabled"}, matchIfMissing=true)
    @Lazy(value=false)
    PolymorphicModelConverter polymorphicModelConverter() {
        return new PolymorphicModelConverter();
    }

    @Bean
    @ConditionalOnMissingBean
    OpenAPIService openAPIBuilder(Optional<OpenAPI> openAPI, ApplicationContext context, SecurityService securityParser, SpringDocConfigProperties springDocConfigProperties, Optional<List<OpenApiBuilderCustomizer>> openApiBuilderCustomisers) {
        return new OpenAPIService(openAPI, context, securityParser, springDocConfigProperties, openApiBuilderCustomisers);
    }

    @Bean
    @Lazy(value=false)
    ModelConverterRegistrar modelConverterRegistrar(Optional<List<ModelConverter>> modelConverters) {
        return new ModelConverterRegistrar(modelConverters.orElse(Collections.emptyList()));
    }

    @Bean
    @ConditionalOnMissingBean
    OperationService operationBuilder(GenericParameterService parameterBuilder, RequestBodyService requestBodyService, SecurityService securityParser, PropertyResolverUtils propertyResolverUtils, Optional<JavadocProvider> javadocProvider) {
        return new OperationService(parameterBuilder, requestBodyService, securityParser, propertyResolverUtils, javadocProvider);
    }

    @Bean
    PropertyResolverUtils propertyResolverUtils(ConfigurableBeanFactory factory, MessageSource messageSource, SpringDocConfigProperties springDocConfigProperties) {
        return new PropertyResolverUtils(factory, messageSource, springDocConfigProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    RequestBodyService requestBodyBuilder(GenericParameterService parameterBuilder) {
        return new RequestBodyService(parameterBuilder);
    }

    @Bean
    @ConditionalOnMissingBean
    SecurityService securityParser(PropertyResolverUtils propertyResolverUtils) {
        return new SecurityService(propertyResolverUtils);
    }

    @Bean
    @Lazy(value=false)
    ReturnTypeParser genericReturnTypeParser() {
        return new ReturnTypeParser(){};
    }

    @Bean
    @ConditionalOnMissingBean
    GenericParameterService parameterBuilder(PropertyResolverUtils propertyResolverUtils, Optional<DelegatingMethodParameterCustomizer> optionalDelegatingMethodParameterCustomizer, Optional<WebConversionServiceProvider> optionalWebConversionServiceProvider) {
        return new GenericParameterService(propertyResolverUtils, optionalDelegatingMethodParameterCustomizer, optionalWebConversionServiceProvider);
    }

    @Bean
    @ConditionalOnProperty(value={"springdoc.api-docs.resolve-schema-properties"})
    @Lazy(value=false)
    OpenApiCustomiser propertiesResolverForSchema(OpenAPIService openAPIService) {
        return openApi -> {
            Components components = openApi.getComponents();
            Map schemas = components.getSchemas();
            if (!CollectionUtils.isEmpty((Map)schemas)) {
                schemas.values().forEach(schema -> openAPIService.resolveProperties((Schema)schema, Locale.getDefault()));
            }
        };
    }

    @Bean
    @Conditional(value={CacheOrGroupedOpenApiCondition.class})
    @ConditionalOnClass(name={"org.springframework.boot.context.properties.bind.BindResult"})
    @Lazy(value=false)
    static BeanFactoryPostProcessor springdocBeanFactoryPostProcessor() {
        return new SpringdocBeanFactoryConfigurer();
    }

    @Bean
    @Conditional(value={CacheOrGroupedOpenApiCondition.class})
    @ConditionalOnMissingClass(value={"org.springframework.boot.context.properties.bind.BindResult"})
    @Lazy(value=false)
    static BeanFactoryPostProcessor springdocBeanFactoryPostProcessor2() {
        return SpringdocBeanFactoryConfigurer::initBeanFactoryPostProcessor;
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    SpringDocProviders springDocProviders(Optional<ActuatorProvider> actuatorProvider, Optional<CloudFunctionProvider> springCloudFunctionProvider, Optional<SecurityOAuth2Provider> springSecurityOAuth2Provider, Optional<RepositoryRestResourceProvider> repositoryRestResourceProvider, Optional<RouterFunctionProvider> routerFunctionProvider) {
        return new SpringDocProviders(actuatorProvider, springCloudFunctionProvider, springSecurityOAuth2Provider, repositoryRestResourceProvider, routerFunctionProvider);
    }

    static {
        SpringDocUtils.getConfig().replaceWithSchema(ObjectNode.class, (Schema)new ObjectSchema()).replaceWithClass(Charset.class, String.class).addResponseWrapperToIgnore(DeferredResult.class);
    }

    @ConditionalOnClass(value={FunctionEndpointInitializer.class})
    @ConditionalOnProperty(name={"springdoc.show-spring-cloud-functions"}, matchIfMissing=true)
    static class SpringDocFunctionCatalogConfiguration {
        SpringDocFunctionCatalogConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @Lazy(value=false)
        CloudFunctionProvider springCloudFunctionProvider(Optional<FunctionCatalog> functionCatalog, GenericResponseService genericResponseService, SpringDocConfigProperties springDocConfigProperties, ApplicationContext applicationContext) {
            return new SpringCloudFunctionProvider(functionCatalog, genericResponseService, springDocConfigProperties, applicationContext);
        }
    }

    @ConditionalOnClass(value={org.springframework.data.domain.Pageable.class})
    static class SpringDocPageableConfiguration {
        SpringDocPageableConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(name={"springdoc.model-converters.pageable-converter.enabled"}, matchIfMissing=true)
        @Lazy(value=false)
        PageableOpenAPIConverter pageableOpenAPIConverter() {
            SpringDocUtils.getConfig().replaceParameterObjectWithClass(org.springframework.data.domain.Pageable.class, Pageable.class).replaceParameterObjectWithClass(PageRequest.class, Pageable.class);
            return new PageableOpenAPIConverter();
        }
    }

    @ConditionalOnClass(value={WebConversionService.class})
    static class WebConversionServiceConfiguration {
        WebConversionServiceConfiguration() {
        }

        @Bean
        @Lazy(value=false)
        WebConversionServiceProvider webConversionServiceProvider(Optional<WebConversionService> webConversionServiceOptional) {
            return new WebConversionServiceProvider(webConversionServiceOptional);
        }
    }

    @ConditionalOnClass(value={WebEndpointProperties.class})
    @ConditionalOnProperty(value={"springdoc.show-actuator"})
    static class SpringDocActuatorConfiguration {
        SpringDocActuatorConfiguration() {
        }

        @Bean
        @Lazy(value=false)
        @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
        @Conditional(value={MultipleOpenApiSupportCondition.class})
        static BeanFactoryPostProcessor springdocBeanFactoryPostProcessor3(List<GroupedOpenApi> groupedOpenApis) {
            return new SpringdocActuatorBeanFactoryConfigurer(groupedOpenApis);
        }

        @Bean
        @Lazy(value=false)
        @ConditionalOnManagementPort(value=ManagementPortType.SAME)
        OperationCustomizer actuatorCustomizer() {
            return new ActuatorOperationCustomizer();
        }

        @Bean
        @Lazy(value=false)
        @ConditionalOnManagementPort(value=ManagementPortType.SAME)
        OpenApiCustomiser actuatorOpenApiCustomiser(WebEndpointProperties webEndpointProperties) {
            return new ActuatorOpenApiCustomizer(webEndpointProperties);
        }
    }

    @RestControllerAdvice
    @Hidden
    class OpenApiResourceAdvice {
        OpenApiResourceAdvice() {
        }

        @ExceptionHandler(value={OpenApiResourceNotFoundException.class})
        @ResponseStatus(value=HttpStatus.NOT_FOUND)
        public ResponseEntity<ErrorMessage> handleNoHandlerFound(OpenApiResourceNotFoundException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)new ErrorMessage(e.getMessage()));
        }
    }
}

