/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.minimax;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.AbstractToolCallSupport;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.chat.model.StreamingChatModel;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.minimax.MiniMaxChatOptions;
import org.springframework.ai.minimax.api.MiniMaxApi;
import org.springframework.ai.minimax.api.MiniMaxApiConstants;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackResolver;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MiniMaxChatModel
extends AbstractToolCallSupport
implements ChatModel,
StreamingChatModel {
    private static final Logger logger = LoggerFactory.getLogger(MiniMaxChatModel.class);
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultChatModelObservationConvention();
    public final RetryTemplate retryTemplate;
    private final MiniMaxChatOptions defaultOptions;
    private final MiniMaxApi miniMaxApi;
    private final ObservationRegistry observationRegistry;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public MiniMaxChatModel(MiniMaxApi miniMaxApi) {
        this(miniMaxApi, MiniMaxChatOptions.builder().model(MiniMaxApi.DEFAULT_CHAT_MODEL).temperature(0.7).build());
    }

    public MiniMaxChatModel(MiniMaxApi miniMaxApi, MiniMaxChatOptions options) {
        this(miniMaxApi, options, null, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public MiniMaxChatModel(MiniMaxApi miniMaxApi, MiniMaxChatOptions options, FunctionCallbackResolver functionCallbackResolver, RetryTemplate retryTemplate) {
        this(miniMaxApi, options, functionCallbackResolver, List.of(), retryTemplate, ObservationRegistry.NOOP);
    }

    public MiniMaxChatModel(MiniMaxApi miniMaxApi, MiniMaxChatOptions options, FunctionCallbackResolver functionCallbackResolver, List<FunctionCallback> toolFunctionCallbacks, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        super(functionCallbackResolver, (FunctionCallingOptions)options, toolFunctionCallbacks);
        Assert.notNull((Object)miniMaxApi, (String)"MiniMaxApi must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"RetryTemplate must not be null");
        Assert.isTrue((boolean)CollectionUtils.isEmpty(options.getFunctionCallbacks()), (String)"The default function callbacks must be set via the toolFunctionCallbacks constructor parameter");
        Assert.notNull((Object)observationRegistry, (String)"ObservationRegistry must not be null");
        this.miniMaxApi = miniMaxApi;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
    }

    private static Generation buildGeneration(MiniMaxApi.ChatCompletion.Choice choice, Map<String, Object> metadata) {
        List toolCalls = choice.message().toolCalls() == null ? List.of() : (List)choice.message().toolCalls().stream().reduce(new ArrayList(), (acc, current) -> {
            if (!acc.isEmpty() && current.id().isEmpty()) {
                AssistantMessage.ToolCall prev = (AssistantMessage.ToolCall)acc.get(acc.size() - 1);
                acc.set(acc.size() - 1, new AssistantMessage.ToolCall(prev.id(), prev.type(), prev.name(), current.function().arguments()));
            } else {
                AssistantMessage.ToolCall currentToolCall = new AssistantMessage.ToolCall(current.id(), current.type(), current.function().name(), current.function().arguments());
                acc.add(currentToolCall);
            }
            return acc;
        }, (acc1, acc2) -> {
            acc1.addAll(acc2);
            return acc1;
        });
        AssistantMessage assistantMessage = new AssistantMessage(choice.message().content(), metadata, toolCalls);
        String finishReason = choice.finishReason() != null ? choice.finishReason().name() : "";
        ChatGenerationMetadata generationMetadata = ChatGenerationMetadata.builder().finishReason(finishReason).build();
        return new Generation(assistantMessage, generationMetadata);
    }

    public ChatResponse call(Prompt prompt) {
        MiniMaxApi.ChatCompletionRequest request = this.createRequest(prompt, false);
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(MiniMaxApiConstants.PROVIDER_NAME).requestOptions(this.buildRequestOptions(request)).build();
        ChatResponse response = (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ResponseEntity completionEntity = (ResponseEntity)this.retryTemplate.execute(ctx -> this.miniMaxApi.chatCompletionEntity(request));
            MiniMaxApi.ChatCompletion chatCompletion = (MiniMaxApi.ChatCompletion)completionEntity.getBody();
            if (chatCompletion == null) {
                logger.warn("No chat completion returned for prompt: {}", (Object)prompt);
                return new ChatResponse(List.of());
            }
            List<MiniMaxApi.ChatCompletion.Choice> choices = chatCompletion.choices();
            if (choices == null) {
                logger.warn("No choices returned for prompt: {}, because: {}}", (Object)prompt, (Object)chatCompletion.baseResponse().message());
                return new ChatResponse(List.of());
            }
            List<Generation> generations = choices.stream().map(choice -> {
                MiniMaxApi.ChatCompletionMessage message = null;
                if (choice.message() != null) {
                    message = choice.message();
                } else if (!CollectionUtils.isEmpty(choice.messages())) {
                    message = choice.messages().get(choice.messages().size() - 1);
                }
                Map<String, Object> metadata = Map.of("id", chatCompletion.id(), "role", message != null && message.role() != null ? message.role().name() : "", "finishReason", choice.finishReason() != null ? choice.finishReason().name() : "");
                return this.buildGeneration(message, choice.finishReason(), metadata);
            }).toList();
            ChatResponse chatResponse = new ChatResponse(generations, this.from((MiniMaxApi.ChatCompletion)completionEntity.getBody()));
            observationContext.setResponse((Object)chatResponse);
            return chatResponse;
        });
        if (!this.isProxyToolCalls(prompt, this.defaultOptions) && this.isToolCall(response, Set.of(MiniMaxApi.ChatCompletionFinishReason.TOOL_CALLS.name(), MiniMaxApi.ChatCompletionFinishReason.STOP.name()))) {
            List toolCallConversation = this.handleToolCalls(prompt, response);
            return this.call(new Prompt(toolCallConversation, prompt.getOptions()));
        }
        return response;
    }

    public ChatOptions getDefaultOptions() {
        return MiniMaxChatOptions.fromOptions(this.defaultOptions);
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        return Flux.deferContextual(contextView -> {
            MiniMaxApi.ChatCompletionRequest request = this.createRequest(prompt, true);
            Flux completionChunks = (Flux)this.retryTemplate.execute(ctx -> this.miniMaxApi.chatCompletionStream(request));
            ConcurrentHashMap roleMap = new ConcurrentHashMap();
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(MiniMaxApiConstants.PROVIDER_NAME).requestOptions(this.buildRequestOptions(request)).build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            Flux chatResponse = completionChunks.map(this::chunkToChatCompletion).switchMap(chatCompletion -> Mono.just((Object)chatCompletion).map(chatCompletion2 -> {
                try {
                    String id = chatCompletion2.id();
                    List<Generation> generations = chatCompletion2.choices().stream().map(choice -> {
                        if (choice.message().role() != null) {
                            roleMap.putIfAbsent(id, choice.message().role().name());
                        }
                        Map<String, Object> metadata = Map.of("id", chatCompletion2.id(), "role", roleMap.getOrDefault(id, ""), "finishReason", choice.finishReason() != null ? choice.finishReason().name() : "");
                        return MiniMaxChatModel.buildGeneration(choice, metadata);
                    }).toList();
                    return new ChatResponse(generations, this.from((MiniMaxApi.ChatCompletion)chatCompletion2));
                }
                catch (Exception e) {
                    logger.error("Error processing chat completion", (Throwable)e);
                    return new ChatResponse(List.of());
                }
            }));
            Flux flux = chatResponse.flatMap(response -> {
                if (!this.isProxyToolCalls(prompt, this.defaultOptions) && this.isToolCall((ChatResponse)response, Set.of(MiniMaxApi.ChatCompletionFinishReason.TOOL_CALLS.name(), MiniMaxApi.ChatCompletionFinishReason.STOP.name()))) {
                    List toolCallConversation = this.handleToolCalls(prompt, (ChatResponse)response);
                    return this.stream(new Prompt(toolCallConversation, prompt.getOptions()));
                }
                return Flux.just((Object)response);
            }).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(signalType -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
            return new MessageAggregator().aggregate(flux, arg_0 -> ((ChatModelObservationContext)observationContext).setResponse(arg_0));
        });
    }

    protected boolean isToolCall(Generation generation, Set<String> toolCallFinishReasons) {
        if (!super.isToolCall(generation, toolCallFinishReasons)) {
            return false;
        }
        return generation.getOutput().getToolCalls().stream().anyMatch(toolCall -> "function".equals(toolCall.type()));
    }

    private ChatOptions buildRequestOptions(MiniMaxApi.ChatCompletionRequest request) {
        return ChatOptions.builder().model(request.model()).frequencyPenalty(request.frequencyPenalty()).maxTokens(request.maxTokens()).presencePenalty(request.presencePenalty()).stopSequences(request.stop()).temperature(request.temperature()).topP(request.topP()).build();
    }

    private ChatResponseMetadata from(MiniMaxApi.ChatCompletion result) {
        Assert.notNull((Object)result, (String)"MiniMax ChatCompletionResult must not be null");
        return ChatResponseMetadata.builder().id(result.id() != null ? result.id() : "").usage((Usage)(result.usage() != null ? this.getDefaultUsage(result.usage()) : new EmptyUsage())).model(result.model() != null ? result.model() : "").keyValue("created", (Object)(result.created() != null ? result.created() : 0L)).keyValue("system-fingerprint", (Object)(result.systemFingerprint() != null ? result.systemFingerprint() : "")).build();
    }

    private DefaultUsage getDefaultUsage(MiniMaxApi.Usage usage) {
        return new DefaultUsage(usage.promptTokens(), usage.completionTokens(), usage.totalTokens(), (Object)usage);
    }

    private Generation buildGeneration(MiniMaxApi.ChatCompletionMessage message, MiniMaxApi.ChatCompletionFinishReason completionFinishReason, Map<String, Object> metadata) {
        if (message == null || message.role() == MiniMaxApi.ChatCompletionMessage.Role.TOOL) {
            return null;
        }
        List toolCalls = message.toolCalls() == null ? List.of() : message.toolCalls().stream().map(toolCall -> new AssistantMessage.ToolCall(toolCall.id(), toolCall.type(), toolCall.function().name(), toolCall.function().arguments())).toList();
        AssistantMessage assistantMessage = new AssistantMessage(message.content(), metadata, toolCalls);
        String finishReason = completionFinishReason != null ? completionFinishReason.name() : "";
        ChatGenerationMetadata generationMetadata = ChatGenerationMetadata.builder().finishReason(finishReason).build();
        return new Generation(assistantMessage, generationMetadata);
    }

    private MiniMaxApi.ChatCompletion chunkToChatCompletion(MiniMaxApi.ChatCompletionChunk chunk) {
        List<MiniMaxApi.ChatCompletion.Choice> choices = chunk.choices().stream().map(cc -> {
            MiniMaxApi.ChatCompletionMessage delta = cc.delta();
            if (delta == null) {
                delta = new MiniMaxApi.ChatCompletionMessage("", MiniMaxApi.ChatCompletionMessage.Role.ASSISTANT);
            }
            return new MiniMaxApi.ChatCompletion.Choice(cc.finishReason(), cc.index(), delta, null, cc.logprobs());
        }).toList();
        return new MiniMaxApi.ChatCompletion(chunk.id(), choices, chunk.created(), chunk.model(), chunk.systemFingerprint(), "chat.completion", null, null);
    }

    MiniMaxApi.ChatCompletionRequest createRequest(Prompt prompt, boolean stream) {
        List<MiniMaxApi.ChatCompletionMessage> chatCompletionMessages = prompt.getInstructions().stream().map(message -> {
            if (message.getMessageType() == MessageType.USER || message.getMessageType() == MessageType.SYSTEM) {
                String content = message.getText();
                return List.of(new MiniMaxApi.ChatCompletionMessage(content, MiniMaxApi.ChatCompletionMessage.Role.valueOf(message.getMessageType().name())));
            }
            if (message.getMessageType() == MessageType.ASSISTANT) {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                List<MiniMaxApi.ChatCompletionMessage.ToolCall> toolCalls = null;
                if (!CollectionUtils.isEmpty((Collection)assistantMessage.getToolCalls())) {
                    toolCalls = assistantMessage.getToolCalls().stream().map(toolCall -> {
                        MiniMaxApi.ChatCompletionMessage.ChatCompletionFunction function = new MiniMaxApi.ChatCompletionMessage.ChatCompletionFunction(toolCall.name(), toolCall.arguments());
                        return new MiniMaxApi.ChatCompletionMessage.ToolCall(toolCall.id(), toolCall.type(), function);
                    }).toList();
                }
                return List.of(new MiniMaxApi.ChatCompletionMessage(assistantMessage.getText(), MiniMaxApi.ChatCompletionMessage.Role.ASSISTANT, null, null, toolCalls));
            }
            if (message.getMessageType() == MessageType.TOOL) {
                ToolResponseMessage toolMessage = (ToolResponseMessage)message;
                toolMessage.getResponses().forEach(response -> Assert.isTrue((response.id() != null ? 1 : 0) != 0, (String)"ToolResponseMessage must have an id"));
                return toolMessage.getResponses().stream().map(tr -> new MiniMaxApi.ChatCompletionMessage(tr.responseData(), MiniMaxApi.ChatCompletionMessage.Role.TOOL, tr.name(), tr.id(), null)).toList();
            }
            throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(message.getMessageType()));
        }).flatMap(Collection::stream).toList();
        MiniMaxApi.ChatCompletionRequest request = new MiniMaxApi.ChatCompletionRequest(chatCompletionMessages, stream);
        HashSet<String> enabledToolsToUse = new HashSet<String>();
        if (prompt.getOptions() != null) {
            MiniMaxChatOptions updatedRuntimeOptions;
            ChatOptions chatOptions = prompt.getOptions();
            if (chatOptions instanceof FunctionCallingOptions) {
                FunctionCallingOptions functionCallingOptions = (FunctionCallingOptions)chatOptions;
                updatedRuntimeOptions = (MiniMaxChatOptions)ModelOptionsUtils.copyToTarget((Object)functionCallingOptions, FunctionCallingOptions.class, MiniMaxChatOptions.class);
            } else {
                updatedRuntimeOptions = (MiniMaxChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, MiniMaxChatOptions.class);
            }
            enabledToolsToUse.addAll(this.runtimeFunctionCallbackConfigurations(updatedRuntimeOptions));
            request = (MiniMaxApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)request, MiniMaxApi.ChatCompletionRequest.class);
        }
        if (!CollectionUtils.isEmpty(this.defaultOptions.getFunctions())) {
            enabledToolsToUse.addAll(this.defaultOptions.getFunctions());
        }
        request = (MiniMaxApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)request, (Object)this.defaultOptions, MiniMaxApi.ChatCompletionRequest.class);
        if (!CollectionUtils.isEmpty(enabledToolsToUse)) {
            request = (MiniMaxApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)MiniMaxChatOptions.builder().tools(this.getFunctionTools(enabledToolsToUse)).build(), (Object)request, MiniMaxApi.ChatCompletionRequest.class);
        }
        return request;
    }

    private List<MiniMaxApi.FunctionTool> getFunctionTools(Set<String> functionNames) {
        return this.resolveFunctionCallbacks(functionNames).stream().map(functionCallback -> {
            MiniMaxApi.FunctionTool.Function function = new MiniMaxApi.FunctionTool.Function(functionCallback.getDescription(), functionCallback.getName(), functionCallback.getInputTypeSchema());
            return new MiniMaxApi.FunctionTool(function);
        }).toList();
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        this.observationConvention = observationConvention;
    }
}

