/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.moonshot;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.metadata.UsageUtils;
import org.springframework.ai.chat.model.AbstractToolCallSupport;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.chat.model.StreamingChatModel;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackResolver;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.ai.moonshot.MoonshotChatOptions;
import org.springframework.ai.moonshot.api.MoonshotApi;
import org.springframework.ai.moonshot.api.MoonshotConstants;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MoonshotChatModel
extends AbstractToolCallSupport
implements ChatModel,
StreamingChatModel {
    private static final Logger logger = LoggerFactory.getLogger(MoonshotChatModel.class);
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultChatModelObservationConvention();
    private final MoonshotChatOptions defaultOptions;
    private final MoonshotApi moonshotApi;
    private final RetryTemplate retryTemplate;
    private final ObservationRegistry observationRegistry;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public MoonshotChatModel(MoonshotApi moonshotApi) {
        this(moonshotApi, MoonshotChatOptions.builder().model(MoonshotApi.DEFAULT_CHAT_MODEL).build());
    }

    public MoonshotChatModel(MoonshotApi moonshotApi, MoonshotChatOptions options) {
        this(moonshotApi, options, null, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public MoonshotChatModel(MoonshotApi moonshotApi, MoonshotChatOptions options, FunctionCallbackResolver functionCallbackResolver, RetryTemplate retryTemplate) {
        this(moonshotApi, options, functionCallbackResolver, List.of(), retryTemplate, ObservationRegistry.NOOP);
    }

    public MoonshotChatModel(MoonshotApi moonshotApi, MoonshotChatOptions options, FunctionCallbackResolver functionCallbackResolver, List<FunctionCallback> toolFunctionCallbacks, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        super(functionCallbackResolver, (FunctionCallingOptions)options, toolFunctionCallbacks);
        Assert.notNull((Object)moonshotApi, (String)"MoonshotApi must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"RetryTemplate must not be null");
        Assert.isTrue((boolean)CollectionUtils.isEmpty(options.getFunctionCallbacks()), (String)"The default function callbacks must be set via the toolFunctionCallbacks constructor parameter");
        Assert.notNull((Object)observationRegistry, (String)"ObservationRegistry must not be null");
        this.moonshotApi = moonshotApi;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
    }

    private static Generation buildGeneration(MoonshotApi.ChatCompletion.Choice choice, Map<String, Object> metadata) {
        List toolCalls = choice.message().toolCalls() == null ? List.of() : choice.message().toolCalls().stream().map(toolCall -> new AssistantMessage.ToolCall(toolCall.id(), "function", toolCall.function().name(), toolCall.function().arguments())).toList();
        AssistantMessage assistantMessage = new AssistantMessage(choice.message().content(), metadata, toolCalls);
        String finishReason = choice.finishReason() != null ? choice.finishReason().name() : "";
        ChatGenerationMetadata generationMetadata = ChatGenerationMetadata.builder().finishReason(finishReason).build();
        return new Generation(assistantMessage, generationMetadata);
    }

    public ChatResponse call(Prompt prompt) {
        return this.internalCall(prompt, null);
    }

    public ChatResponse internalCall(Prompt prompt, ChatResponse previousChatResponse) {
        MoonshotApi.ChatCompletionRequest request = this.createRequest(prompt, false);
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(MoonshotConstants.PROVIDER_NAME).requestOptions(this.buildRequestOptions(request)).build();
        ChatResponse response = (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ResponseEntity completionEntity = (ResponseEntity)this.retryTemplate.execute(ctx -> this.moonshotApi.chatCompletionEntity(request));
            MoonshotApi.ChatCompletion chatCompletion = (MoonshotApi.ChatCompletion)completionEntity.getBody();
            if (chatCompletion == null) {
                logger.warn("No chat completion returned for prompt: {}", (Object)prompt);
                return new ChatResponse(List.of());
            }
            List<MoonshotApi.ChatCompletion.Choice> choices = chatCompletion.choices();
            if (choices == null) {
                logger.warn("No choices returned for prompt: {}", (Object)prompt);
                return new ChatResponse(List.of());
            }
            List<Generation> generations = choices.stream().map(choice -> {
                Map<String, Object> metadata = Map.of("id", chatCompletion.id(), "role", choice.message().role() != null ? choice.message().role().name() : "", "finishReason", choice.finishReason() != null ? choice.finishReason().name() : "");
                return MoonshotChatModel.buildGeneration(choice, metadata);
            }).toList();
            MoonshotApi.Usage usage = ((MoonshotApi.ChatCompletion)completionEntity.getBody()).usage();
            EmptyUsage currentUsage = usage != null ? this.getDefaultUsage(usage) : new EmptyUsage();
            Usage cumulativeUsage = UsageUtils.getCumulativeUsage((Usage)currentUsage, (ChatResponse)previousChatResponse);
            ChatResponse chatResponse = new ChatResponse(generations, this.from((MoonshotApi.ChatCompletion)completionEntity.getBody(), cumulativeUsage));
            observationContext.setResponse((Object)chatResponse);
            return chatResponse;
        });
        if (!this.isProxyToolCalls(prompt, this.defaultOptions) && this.isToolCall(response, Set.of(MoonshotApi.ChatCompletionFinishReason.TOOL_CALLS.name(), MoonshotApi.ChatCompletionFinishReason.STOP.name()))) {
            List toolCallConversation = this.handleToolCalls(prompt, response);
            return this.internalCall(new Prompt(toolCallConversation, prompt.getOptions()), response);
        }
        return response;
    }

    private DefaultUsage getDefaultUsage(MoonshotApi.Usage usage) {
        return new DefaultUsage(usage.promptTokens(), usage.completionTokens(), usage.totalTokens(), (Object)usage);
    }

    public ChatOptions getDefaultOptions() {
        return this.defaultOptions.copy();
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        return this.internalStream(prompt, null);
    }

    public Flux<ChatResponse> internalStream(Prompt prompt, ChatResponse previousChatResponse) {
        return Flux.deferContextual(contextView -> {
            MoonshotApi.ChatCompletionRequest request = this.createRequest(prompt, true);
            Flux completionChunks = (Flux)this.retryTemplate.execute(ctx -> this.moonshotApi.chatCompletionStream(request));
            ConcurrentHashMap roleMap = new ConcurrentHashMap();
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(MoonshotConstants.PROVIDER_NAME).requestOptions(this.buildRequestOptions(request)).build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            Flux chatResponse = completionChunks.map(this::chunkToChatCompletion).switchMap(chatCompletion -> Mono.just((Object)chatCompletion).map(chatCompletion2 -> {
                try {
                    String id = chatCompletion2.id();
                    List<Generation> generations = chatCompletion2.choices().stream().map(choice -> {
                        if (choice.message().role() != null) {
                            roleMap.putIfAbsent(id, choice.message().role().name());
                        }
                        Map<String, Object> metadata = Map.of("id", chatCompletion2.id(), "role", roleMap.getOrDefault(id, ""), "finishReason", choice.finishReason() != null ? choice.finishReason().name() : "");
                        return MoonshotChatModel.buildGeneration(choice, metadata);
                    }).toList();
                    MoonshotApi.Usage usage = chatCompletion2.usage();
                    EmptyUsage currentUsage = usage != null ? this.getDefaultUsage(usage) : new EmptyUsage();
                    Usage cumulativeUsage = UsageUtils.getCumulativeUsage((Usage)currentUsage, (ChatResponse)previousChatResponse);
                    return new ChatResponse(generations, this.from((MoonshotApi.ChatCompletion)chatCompletion2, cumulativeUsage));
                }
                catch (Exception e) {
                    logger.error("Error processing chat completion", (Throwable)e);
                    return new ChatResponse(List.of());
                }
            }));
            Flux flux = chatResponse.flatMap(response -> {
                if (!this.isProxyToolCalls(prompt, this.defaultOptions) && this.isToolCall((ChatResponse)response, Set.of(MoonshotApi.ChatCompletionFinishReason.TOOL_CALLS.name(), MoonshotApi.ChatCompletionFinishReason.STOP.name()))) {
                    List toolCallConversation = this.handleToolCalls(prompt, (ChatResponse)response);
                    return this.internalStream(new Prompt(toolCallConversation, prompt.getOptions()), (ChatResponse)response);
                }
                return Flux.just((Object)response);
            }).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(signalType -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
            return new MessageAggregator().aggregate(flux, arg_0 -> ((ChatModelObservationContext)observationContext).setResponse(arg_0));
        });
    }

    private ChatResponseMetadata from(MoonshotApi.ChatCompletion result) {
        Assert.notNull((Object)result, (String)"Moonshot ChatCompletionResult must not be null");
        return ChatResponseMetadata.builder().id(result.id() != null ? result.id() : "").usage((Usage)(result.usage() != null ? this.getDefaultUsage(result.usage()) : new EmptyUsage())).model(result.model() != null ? result.model() : "").keyValue("created", (Object)(result.created() != null ? result.created() : 0L)).build();
    }

    private ChatResponseMetadata from(MoonshotApi.ChatCompletion result, Usage usage) {
        Assert.notNull((Object)result, (String)"Moonshot ChatCompletionResult must not be null");
        return ChatResponseMetadata.builder().id(result.id() != null ? result.id() : "").usage(usage).model(result.model() != null ? result.model() : "").keyValue("created", (Object)(result.created() != null ? result.created() : 0L)).build();
    }

    private MoonshotApi.ChatCompletion chunkToChatCompletion(MoonshotApi.ChatCompletionChunk chunk) {
        List<MoonshotApi.ChatCompletion.Choice> choices = chunk.choices().stream().map(cc -> {
            MoonshotApi.ChatCompletionMessage delta = cc.delta();
            if (delta == null) {
                delta = new MoonshotApi.ChatCompletionMessage("", MoonshotApi.ChatCompletionMessage.Role.ASSISTANT);
            }
            return new MoonshotApi.ChatCompletion.Choice(cc.index(), delta, cc.finishReason(), cc.usage());
        }).toList();
        MoonshotApi.Usage usage = choices.get(choices.size() - 1).usage();
        return new MoonshotApi.ChatCompletion(chunk.id(), "chat.completion", chunk.created(), chunk.model(), choices, usage);
    }

    public MoonshotApi.ChatCompletionRequest createRequest(Prompt prompt, boolean stream) {
        List<MoonshotApi.ChatCompletionMessage> chatCompletionMessages = prompt.getInstructions().stream().map(message -> {
            if (message.getMessageType() == MessageType.USER || message.getMessageType() == MessageType.SYSTEM) {
                String content = message.getText();
                return List.of(new MoonshotApi.ChatCompletionMessage(content, MoonshotApi.ChatCompletionMessage.Role.valueOf(message.getMessageType().name())));
            }
            if (message.getMessageType() == MessageType.ASSISTANT) {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                List<MoonshotApi.ChatCompletionMessage.ToolCall> toolCalls = null;
                if (!CollectionUtils.isEmpty((Collection)assistantMessage.getToolCalls())) {
                    toolCalls = assistantMessage.getToolCalls().stream().map(toolCall -> {
                        MoonshotApi.ChatCompletionMessage.ChatCompletionFunction function = new MoonshotApi.ChatCompletionMessage.ChatCompletionFunction(toolCall.name(), toolCall.arguments());
                        return new MoonshotApi.ChatCompletionMessage.ToolCall(toolCall.id(), toolCall.type(), function);
                    }).toList();
                }
                return List.of(new MoonshotApi.ChatCompletionMessage(assistantMessage.getText(), MoonshotApi.ChatCompletionMessage.Role.ASSISTANT, null, null, toolCalls));
            }
            if (message.getMessageType() == MessageType.TOOL) {
                ToolResponseMessage toolMessage = (ToolResponseMessage)message;
                toolMessage.getResponses().forEach(response -> Assert.isTrue((response.id() != null ? 1 : 0) != 0, (String)"ToolResponseMessage must have an id"));
                return toolMessage.getResponses().stream().map(tr -> new MoonshotApi.ChatCompletionMessage(tr.responseData(), MoonshotApi.ChatCompletionMessage.Role.TOOL, tr.name(), tr.id(), null)).toList();
            }
            throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(message.getMessageType()));
        }).flatMap(Collection::stream).toList();
        MoonshotApi.ChatCompletionRequest request = new MoonshotApi.ChatCompletionRequest(chatCompletionMessages, stream);
        HashSet<String> enabledToolsToUse = new HashSet<String>();
        if (prompt.getOptions() != null) {
            MoonshotChatOptions updatedRuntimeOptions;
            ChatOptions chatOptions = prompt.getOptions();
            if (chatOptions instanceof FunctionCallingOptions) {
                FunctionCallingOptions functionCallingOptions = (FunctionCallingOptions)chatOptions;
                updatedRuntimeOptions = (MoonshotChatOptions)ModelOptionsUtils.copyToTarget((Object)functionCallingOptions, FunctionCallingOptions.class, MoonshotChatOptions.class);
            } else {
                updatedRuntimeOptions = (MoonshotChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, MoonshotChatOptions.class);
            }
            enabledToolsToUse.addAll(this.runtimeFunctionCallbackConfigurations(updatedRuntimeOptions));
            request = (MoonshotApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)request, MoonshotApi.ChatCompletionRequest.class);
        }
        if (!CollectionUtils.isEmpty(this.defaultOptions.getFunctions())) {
            enabledToolsToUse.addAll(this.defaultOptions.getFunctions());
        }
        request = (MoonshotApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)request, (Object)this.defaultOptions, MoonshotApi.ChatCompletionRequest.class);
        if (!CollectionUtils.isEmpty(enabledToolsToUse)) {
            request = (MoonshotApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)MoonshotChatOptions.builder().tools(this.getFunctionTools(enabledToolsToUse)).build(), (Object)request, MoonshotApi.ChatCompletionRequest.class);
        }
        return request;
    }

    private ChatOptions buildRequestOptions(MoonshotApi.ChatCompletionRequest request) {
        return ChatOptions.builder().model(request.model()).frequencyPenalty(request.frequencyPenalty()).maxTokens(request.maxTokens()).presencePenalty(request.presencePenalty()).stopSequences(request.stop()).temperature(request.temperature()).topP(request.topP()).build();
    }

    private List<MoonshotApi.FunctionTool> getFunctionTools(Set<String> functionNames) {
        return this.resolveFunctionCallbacks(functionNames).stream().map(functionCallback -> {
            MoonshotApi.FunctionTool.Function function = new MoonshotApi.FunctionTool.Function(functionCallback.getDescription(), functionCallback.getName(), functionCallback.getInputTypeSchema());
            return new MoonshotApi.FunctionTool(function);
        }).toList();
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        this.observationConvention = observationConvention;
    }
}

